import React, { PureComponent } from "react";
import { Link } from "react-router-dom";
import * as myConstClass from "../../constant.js";
import $ from "jquery";
import DatePicker from "react-datepicker";
import TimePicker from "react-time-picker";
import "react-datepicker/dist/react-datepicker.css";
import filterFactory, { textFilter } from "react-bootstrap-table2-filter";
import "./datepicker.scss";
import dateFormat from "dateformat";
import cookie from "react-cookies";
// import CsvDownloader from 'react-csv-downloader';
import swal from "sweetalert";
import { CSVLink } from "react-csv";
import moment from "moment";
import CsvDownloader from "react-csv-downloader";
import {
  Breadcrumb,
  BreadcrumbItem,
  Button,
  Row,
  Col,
  Label,
  Card,
  CardBody,
  CardHeader,
  CardTitle,
  Container,
  Modal,
  ModalBody,
  ModalFooter,
  ModalHeader,
} from "reactstrap";

import Header from "../../components/Header";
import HeaderTitle from "../../components/HeaderTitle";

import BootstrapTable from "react-bootstrap-table-next";
import ToolkitProvider from "react-bootstrap-table2-toolkit";
import paginationFactory from "react-bootstrap-table2-paginator";
import { toastr } from "react-redux-toastr";
import * as Icon from "react-feather";
import { confirmAlert } from "react-confirm-alert"; // Import
import "react-confirm-alert/src/react-confirm-alert.css"; // Import css
import { Redirect } from "react-router-dom";
import {
  AvForm,
  AvField,
  AvGroup,
  AvInput,
  AvFeedback,
  AvRadioGroup,
  AvRadio,
  AvCheckboxGroup,
  AvCheckbox,
} from "availity-reactstrap-validation";

const headers = [
  { label: "Employee", key: "employee_id" },
  { label: "Attendance Date", key: "attendance_date" },
  { label: "In-Time - Out-Time", key: "clock_in" },
  { label: "Total Work", key: "total_work" },
  { label: "Timezone", key: "timezone" },
  { label: "Check in Latitude Longitude", key: "checkin_lat" },
  { label: "Check in Redius Check ", key: "checkout_radius_check" },
  { label: "Check in Distance", key: "checkin_dist" },
  { label: "Check iOut Latitude Longitude", key: "checkout_lat" },
  { label: "Check Out Redius Check", key: "checkout_radius_check" },
  { label: "Check Out Distance", key: "checkout_dist" },
  { label: "Department", key: "department" },
  { label: "Position", key: "designation" },
  { label: "Attendance Notes", key: "attendanceNotes" },
];

const tableColumns = [
  {
    dataField: "employee_id",
    text: "Employee",
    sort: true,
    headerStyle: { width: "10%" },
    // filter: textFilter()
  },
  {
    dataField: "attendance_date",
    text: "Attendance Date",
    sort: true,
    headerStyle: { width: "10%" },
    // filter: textFilter()
  },
  {
    dataField: "clock_in",
    text: "In-Time - Out-Time",
    sort: true,
    headerStyle: { width: "10%" },
    // filter: textFilter()
  },
  {
    dataField: "overtime",
    text: "Over Time",
    sort: true,
    headerStyle: { width: "10%" },
    // filter: textFilter()
  },
  {
    dataField: "early_leaving",
    text: "Early Leaving",
    sort: true,
    headerStyle: { width: "10%" },
    // filter: textFilter()
  },
  {
    dataField: "time_late",
    text: "Time Late",
    sort: true,
    headerStyle: { width: "10%" },
    // filter: textFilter()
  },
  {
    dataField: "total_work",
    text: "Total Work",
    sort: true,
    headerStyle: { width: "10%" },
    // filter: textFilter()
  },
  // {
  //   dataField: "total_work",
  //   text: "Total Work",
  //   sort: true,
  //   headerStyle: { width:"10%" },
  //   // filter: textFilter()
  // },
  // {
  //   dataField: "total_work",
  //   text: "Total Work",
  //   sort: true,
  //   headerStyle: { width:"10%" },
  //   // filter: textFilter()
  // },
  // {
  //   dataField: "timezone",
  //   text: "Timezone",
  //   sort: true,
  //   headerStyle: { width:"10%" },
  //   // filter: textFilter()
  // },
  // {
  //   dataField: "checkin_radius_check",
  //   text: "CheckIn Radius Check",
  //   headerStyle: { width:"15%" },
  //   csvExport:false,
  //   // filter: textFilter()
  // },
  // {
  //   dataField: "checkout_radius_check",
  //   text: "CheckOut Radius Check",
  //   headerStyle: { width:"15%" },
  //   csvExport:false,
  //   // filter: textFilter()
  // },
  {
    dataField: "action",
    text: "Action",
    headerStyle: { width: "10%" },
    csvExport: false,
  },
];
const columns = [
  {
    id: "employee_id",
    displayName: "First column",
  },
  {
    id: "attendance_date",
    displayName: "Second column",
  },
];

const MyExportCSV = (props) => {
  const handleClick = () => {
    props.onExport();
  };
  return (
    <div>
      <button className="btn btn-secondary mt-2" onClick={handleClick}>
        Export
      </button>
    </div>
  );
};

class Attendance extends PureComponent {
  constructor(props) {
    super(props);
    this.routeChange = this.routeChange.bind(this);
    //this.googleTranslateElementInit = this.googleTranslateElementInit.bind(this);
    this.state = {
      user_id: 0,
      from_date: Date.now(),
      to_date: Date.now(),
      formData: "",
      emp: "",
      org: "",
      dep: "",
      pos: "",
      formDataCSV: "",
      sync: "",
      syncHrm: "",
      googleTranslateElementInit: "",
      org_emp: "",
      posts: "",
      timeOut: 5000,
      showCloseButton: true,
      progressBar: true,
      position: "top-right",
      languageCodes: [],
      disabled: false,
      maxdate: moment().subtract(31, "days"),
      export_disabled: true,
      language: cookie.load("language") ? cookie.load("language") : "en",
      question: cookie.load("question")
        ? cookie.load("question")
        : "What language do you prefer to read with?",
    };

    this.flag = 0;
    this.cid = 0;
    this.oid = 0;
    this.change = this.change.bind(this);
    this.ochange = this.ochange.bind(this);
    this.search = this.search.bind(this);
    this.dep_change = this.dep_change.bind(this);
    this.pos_change = this.pos_change.bind(this);
    this.apply_filters = this.apply_filters.bind(this);

    //   submitted: false,

    //for export
    this.csvColumns = [
      {
        displayName: "Employee",
        id: "employee_id",
      },
      { displayName: "Attendance Date", id: "attendance_date" },
      { displayName: "In-Time", id: "clock_in" },
      { displayName: "Out-Time", id: "clock_out" },
      { displayName: "Timezone", id: "timezone" },
    ];
  }

  archievedLeave() {
    this.props.history.push("/attendance/listingdel");
  }

  edit(e) {
    this.props.history.push("/attendance/add/" + e);
  }

  view(e) {
    this.props.history.push("/attendance/view/" + e);
  }

  // remove(e) {
  //   this.flag = 1;
  //   var admin_id = localStorage.getItem('uname');
  //   const options = {
  //       timeOut: parseInt(this.state.timeOut),
  //       showCloseButton: this.state.showCloseButton,
  //       progressBar: this.state.progressBar,
  //       position: this.state.position
  //     };
  //     this.flag = 1;
  //   confirmAlert({
  //     title: '',
  //     message: 'Are you sure ?',
  //     buttons: [
  //       {
  //         label: 'Yes',
  //         onClick: () =>    fetch(myConstClass.BASE_URL+`attendance/deleteAttendance`, {
  //           method: 'POST',
  //           body: e,
  //         }).then(toastr.success(
  //           'Success',
  //           "Attendance Deleted Successfully..!",
  //           options
  //         ),fetch(myConstClass.BASE_URL+'attendance/getAttendance/'+admin_id)
  //         .then(response => response.json())
  //         .then(response =>{
  //           let i=1;
  //           response.rows.forEach(element => {
  //           element.action = <div><Icon.Eye style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.view(element.id)} /><i id={element.id} className="fa fa-remove ptr_css" onClick={() =>this.remove(element.id)}></i><i id={element.id} className="fa fa-edit ptr_css" onClick={() =>this.edit(element.id)}></i></div>;
  //            i++;
  //           });
  //           this.setState({formData: response})
  //         })
  //         .catch(err => console.log(err))
  //         )
  //         .catch()
  //       },
  //       {
  //         label: 'No',
  //         onClick: () => <Redirect to='attendance/listing'  />
  //       }
  //     ]
  //   });
  // }

  remove(e) {
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");

    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }

    swal({
      title: "Are you sure?",
      text: "Are you sure that you want to delete this record?",
      icon: "warning",
      // buttons: true,
      buttons: {
        confirm: {
          text: "OK",
          value: true,
          visible: true,
          className: "",
          closeModal: true,
        },
        cancel: {
          text: "Cancel",
          value: false,
          visible: true,
          className: "Custom_Cancel",
          closeModal: true,
        },
      },
      dangerMode: true,
    }).then((result) => {
      if (result) {
        const options = {
          timeOut: parseInt(this.state.timeOut),
          showCloseButton: this.state.showCloseButton,
          progressBar: this.state.progressBar,
          position: this.state.position,
        };
        this.flag = 1;
        fetch(
          myConstClass.BASE_URL + `/attendance/deleteAttendance/` + admin_id+'/'+e,
          // {
          //   method: "POST",
          //   body: e,
          // }
        )
        .then((response) => response.json())
      .then((response) => {
        //alert('fii');
       // alert();
         // .then(
            toastr.success(
              "Success",
              "Attendance Deleted Successfully..!",
              options
            )
          this.componentDidMount();
           
          // )
          // .catch();
        })
        .catch((err) => console.log(err));
      }
    });

    fetch(
      myConstClass.BASE_URL +
        `/attendance/getAttendanceCSV/` +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => this.setState({ formDataCSV: response }))
      .catch((err) => console.log(err));
  }

  apply_filters() {
    this.setState({ disabled: true });
    this.setState({ export_disabled: true });
    var admin_id = localStorage.getItem("uname");
    this.dep_id = this.dep_id;
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }

    fetch(
      myConstClass.BASE_URL +
        "attendance/getAttendance/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid +
        "/" +
        this.pos_id +
        "/" +
        this.dep_id
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          // let cin = element.checkin_radius_check;
          // if(cin.includes("Out")){
          //   element.checkin_radius_check=<div style={{color:"red"}}>{cin}</div>;
          // } else {
          //   element.checkin_radius_check=<div style={{color:"green"}}>{cin}</div>;
          // }
          // let cout = element.checkout_radius_check;
          // if(cout.includes("Out")){
          //   element.checkout_radius_check=<div style={{color:"red"}}>{cout}</div>;
          // } else {
          //   element.checkout_radius_check=<div style={{color:"green"}}>{cout}</div>;
          // }

          element.action = (
            <div>
              <Icon.Eye
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.view(id)}
              />
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
        this.setState({ disabled: false });
      })
      .catch((err) => console.log(err));

    fetch(
      myConstClass.BASE_URL +
        `/attendance/getAttendanceCSV/` +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid +
        "/" +
        this.pos_id +
        "/" +
        this.dep_id
    )
      .then((response) => response.json())
      .then((response) =>
        this.setState({ formDataCSV: response, export_disabled: false })
      )
      .catch((err) => console.log(err));
  }

  dep_change(event) {
    var admin_id = localStorage.getItem("uname");
    this.dep_id = event.target.value;
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    //      fetch(myConstClass.BASE_URL+'attendance/getAttendance/'+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    //     .then(response => response.json())
    //     .then(response =>{
    //       let i=1;
    //       response.forEach(element => {
    //       let id=element.id;
    //       element.action = <div><Icon.Edit3 style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.edit(id)} /><Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/></div>;
    //       // console.log(element);
    //       element.id = i;
    //       i++;
    //   });
    //   this.setState({formData: response})
    // }).catch(err => console.log(err))

    // fetch(myConstClass.BASE_URL+`/attendance/getAttendanceCSV/`+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    // .then(response => response.json())
    // .then(response =>this.setState({formDataCSV: response})).catch(err => console.log(err))
  }

  pos_change(event) {
    var admin_id = localStorage.getItem("uname");
    this.pos_id = event.target.value;
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }
    //      fetch(myConstClass.BASE_URL+'attendance/getAttendance/'+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    //       .then(response => response.json())
    //       .then(response =>{
    //       let i=1;
    //       response.forEach(element => {
    //       let id=element.id;
    //       element.action = <div><Icon.Edit3 style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.edit(id)} /><Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/></div>;
    //       // console.log(element);
    //       element.id = i;
    //    i++;
    //   });
    //   this.setState({formData: response})
    // }).catch(err => console.log(err))

    // fetch(myConstClass.BASE_URL+`/attendance/getAttendanceCSV/`+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    // .then(response => response.json())
    // .then(response =>this.setState({formDataCSV: response})).catch(err => console.log(err))
  }

  ochange(event) {
    // this.setState({'organization_id':event});
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    this.oid = event.target.value;

    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }

    // fetch(myConstClass.BASE_URL+`/attendance/getAttendanceCSV/`+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    // .then(response => response.json())
    // .then(response =>this.setState({formDataCSV: response})).catch(err => console.log(err))

    //   fetch(myConstClass.BASE_URL+'attendance/getAttendance/'+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    //   .then(response => response.json())
    //   .then(response =>{
    //     let i=1;
    //   response.forEach(element => {
    //     let id=element.id;
    //     let cin = element.checkin_radius_check;
    //     if(cin.includes("Out")){
    //       element.checkin_radius_check=<div style={{color:"red"}}>{cin}</div>;
    //     } else {
    //       element.checkin_radius_check=<div style={{color:"green"}}>{cin}</div>;
    //     }
    //     let cout = element.checkout_radius_check;
    //     if(cout.includes("Out")){
    //       element.checkout_radius_check=<div style={{color:"red"}}>{cout}</div>;
    //     } else {
    //       element.checkout_radius_check=<div style={{color:"green"}}>{cout}</div>;
    //     }

    //   element.action = <div><Icon.Eye style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.view(id)} /><Icon.Edit3 style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.edit(id)} /><Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/></div>;
    //    // console.log(element);
    //    element.id = i;
    //    i++;
    //   });
    //   this.setState({formData: response})
    // }).catch(err => console.log(err))

    fetch(
      myConstClass.BASE_URL +
        "user/get_all_Employees/" +
        admin_id +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        this.setState({ emp: response });
      })
      .catch((err) => console.log(err));
  }

  change(event) {
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    this.cid = event.target.value;

    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }

    // fetch(myConstClass.BASE_URL+`/attendance/getAttendanceCSV/`+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    // .then(response => response.json())
    // .then(response =>this.setState({formDataCSV: response})).catch(err => console.log(err))

    //   fetch(myConstClass.BASE_URL+'attendance/getAttendance/'+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    //   .then(response => response.json())
    //   .then(response =>{
    //     let i=1;
    //   response.forEach(element => {
    //     let id=element.id;
    //     let cin = element.checkin_radius_check;
    //     if(cin.includes("Out")){
    //       element.checkin_radius_check=<div style={{color:"red"}}>{cin}</div>;
    //     } else {
    //       element.checkin_radius_check=<div style={{color:"green"}}>{cin}</div>;
    //     }
    //     let cout = element.checkout_radius_check;
    //     if(cout.includes("Out")){
    //       element.checkout_radius_check=<div style={{color:"red"}}>{cout}</div>;
    //     } else {
    //       element.checkout_radius_check=<div style={{color:"green"}}>{cout}</div>;
    //     }
    //   element.action = <div><Icon.Eye style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.view(id)} /><Icon.Edit3 style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.edit(id)} /><Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/></div>;
    //    // console.log(element);
    //    element.id = i;
    //    i++;
    //   });
    //   this.setState({formData: response})
    // }).catch(err => console.log(err))
  }

  handleFromDateChange = (from_date) => {
    this.setState({ from_date });
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");

    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }

    // fetch(myConstClass.BASE_URL+`/attendance/getAttendanceCSV/`+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    // .then(response => response.json())
    // .then(response =>this.setState({formDataCSV: response})).catch(err => console.log(err))

    // fetch(myConstClass.BASE_URL+'attendance/getAttendanceCSV/'+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid)
    // .then(response => response.json())
    // .then(response =>{this.setState({formDataCSV: response})}).catch(err => console.log(err))

    //   fetch(myConstClass.BASE_URL+'attendance/getAttendance/'+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    //   .then(response => response.json())
    //   .then(response =>{
    //     let i=1;
    //   response.forEach(element => {
    //     let id=element.id;
    //     let cin = element.checkin_radius_check;
    //     if(cin.includes("Out")){
    //       element.checkin_radius_check=<div style={{color:"red"}}>{cin}</div>;
    //     } else {
    //       element.checkin_radius_check=<div style={{color:"green"}}>{cin}</div>;
    //     }
    //     let cout = element.checkout_radius_check;
    //     if(cout.includes("Out")){
    //       element.checkout_radius_check=<div style={{color:"red"}}>{cout}</div>;
    //     } else {
    //       element.checkout_radius_check=<div style={{color:"green"}}>{cout}</div>;
    //     }
    //   element.action = <div><Icon.Eye style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.view(id)} /><Icon.Edit3 style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.edit(id)} /><Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/></div>;
    //    // console.log(element);
    //    element.id = i;
    //    i++;
    //   });
    //   this.setState({formData: response})
    // }).catch(err => console.log(err))
    var from = { from_date };
  };

  handleToDateChange = (to_date) => {
    this.setState({ to_date });

    // maxDate=this.state.from_date.subtract(18, "years");

    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(to_date, "yyyy-mm-dd");

    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }

    // fetch(myConstClass.BASE_URL+`/attendance/getAttendanceCSV/`+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    // .then(response => response.json())
    // .then(response =>this.setState({formDataCSV: response})).catch(err => console.log(err))

    //   fetch(myConstClass.BASE_URL+'attendance/getAttendance/'+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid+'/'+ this.pos_id+'/'+this.dep_id)
    //   .then(response => response.json())
    //   .then(response =>{
    //     let i=1;
    //   response.forEach(element => {
    //     let id=element.id;
    //     let cin = element.checkin_radius_check;
    //     if(cin.includes("Out")){
    //       element.checkin_radius_check=<div style={{color:"red"}}>{cin}</div>;
    //     } else {
    //       element.checkin_radius_check=<div style={{color:"green"}}>{cin}</div>;
    //     }
    //     let cout = element.checkout_radius_check;
    //     if(cout.includes("Out")){
    //       element.checkout_radius_check=<div style={{color:"red"}}>{cout}</div>;
    //     } else {
    //       element.checkout_radius_check=<div style={{color:"green"}}>{cout}</div>;
    //     }
    //   element.action = <div><Icon.Eye style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.view(id)} /><Icon.Edit3 style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.edit(id)} /><Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/></div>;
    //    // console.log(element);
    //    element.id = i;
    //    i++;
    //   });
    //   this.setState({formData: response})
    // }).catch(err => console.log(err))
    var to = { to_date };
  };

  routeChange() {
    this.props.history.push("/");
  }

  // handleSyncToHrm= () => {

  //   var admin_id= localStorage.getItem('uname');
  //   var fdate = dateFormat(this.state.from_date,'yyyy-mm-dd');
  //   var tdate = dateFormat(this.state.to_date,'yyyy-mm-dd');

  //   fetch(myConstClass.BASE_URL+'attendance/getAttendanceToSync/'+admin_id+'/'+this.cid+'/'+fdate+'/'+tdate+'/'+this.oid)
  //   .then(response => response.json())
  //   .then(response =>{
  //     const requestOptions = {
  //       method: 'POST',
  //       headers: { 'Content-Type': 'application/json' },
  //       body: response
  //   };

  //     if(response){
  //       var x = JSON.stringify(response);
  //       fetch("http://angkorair.easyhrm4u.com/api/syncToHrm", {
  //       method: 'POST',
  //       body: JSON.stringify(response),
  //     }).then(response =>  response.json()).then((response) => {

  //     if(response == 0 ){
  //       alert("There are some employees which are not present on HRM system, So cannot be sync");
  //     } else{
  //       alert(response +'Record successfully sync Into HRM system ');
  //     }
  //     }).catch(err => console.log(err))
  //     }else{

  //    }
  // }).catch(err => console.log(err))

  // alert(this.state.sync);

  // $.ajax({
  //   type:'POST',
  //   dataType: 'json',
  //   url: "http://localhost/hrm/employees/syncToHrm",
  //   data:{arr :this.sync },
  //   success:function(response){
  //   }
  // });
  // }

  search(event) {
    var admin_id = localStorage.getItem("uname");
    this.sid = event.target.value;
    if (this.sid == null || this.sid == "") {
      this.sid = 0;
    } else {
      this.sid = event.target.value;
    }
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");

    fetch(
      myConstClass.BASE_URL +
        `/attendance/getAttendanceCSV/` +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => this.setState({ formDataCSV: response }))
      .catch((err) => console.log(err));

    fetch(
      myConstClass.BASE_URL +
        "attendance/getAttendanceOnSearch/" +
        admin_id +
        "/" +
        this.sid +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          let cin = element.checkin_radius_check;
          if (cin.includes("Out")) {
            element.checkin_radius_check = (
              <div style={{ color: "red" }}>{cin}</div>
            );
          } else {
            element.checkin_radius_check = (
              <div style={{ color: "green" }}>{cin}</div>
            );
          }
          let cout = element.checkout_radius_check;
          if (cout.includes("Out")) {
            element.checkout_radius_check = (
              <div style={{ color: "red" }}>{cout}</div>
            );
          } else {
            element.checkout_radius_check = (
              <div style={{ color: "green" }}>{cout}</div>
            );
          }
          element.action = (
            <div>
              <Icon.Eye
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.view(id)}
              />
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
  }
  //  googleTranslateElementInit () {
  //   /* eslint-disable no-new */
  //   const google = window.google;
  //     new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element_1');
  //   new window.google.translate.TranslateElement({pageLanguage: 'pt', layout: window.google.translate.TranslateElement.FloatPosition.TOP_LEFT}, 'google_translate_element_1')
  // }

  componentDidMount() {
    this.setState({ export_disabled: true });

    // window.googleTranslateElementInit = this.googleTranslateElementInit
    // const google = window.google;
    // const script = document.createElement("script");
    // script.src = "//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit";
    // script.async = true;
    // document.body.appendChild(script);

    document.querySelector(".react-bootstrap-table").style.minHeight = "243px";
    var admin_id = localStorage.getItem("uname");
    if (admin_id == null) {
      this.routeChange();
    }
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");

    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }

    fetch(
      myConstClass.BASE_URL + "organization/get_all_organizations/" + admin_id
    )
      .then((response) => response.json())
      .then((response) => {
        // response.forEach((element) => {
        //   this.setState({ organization_id: element.id });
        // });
        response.forEach((element) => {
        if(admin_id!='0')
          {
            this.setState({ organization_id: element.id });
          }
        });
        this.setState({ org: response });
      })
      .catch((err) => console.log(err));

    fetch(
      myConstClass.BASE_URL +
        "attendance/getAttendance/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid +
        "/" +
        this.pos_id +
        "/" +
        this.dep_id
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          element.action = (
            <div>
              <Icon.Eye
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.view(id)}
              />
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));

    fetch(
      myConstClass.BASE_URL +
        "user/get_all_Employees/" +
        admin_id +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        this.setState({ emp: response });
      })
      .catch((err) => console.log(err));

    fetch(
      myConstClass.BASE_URL +
        `/attendance/getAttendanceCSV/` +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid +
        "/" +
        this.pos_id +
        "/" +
        this.dep_id
    )
      .then((response) => response.json())
      .then((response) =>
        this.setState({ formDataCSV: response, export_disabled: false })
      )
      .catch((err) => console.log(err));

    fetch(myConstClass.BASE_URL + "user/get_all_departments/" + admin_id)
      .then((response) => response.json())
      .then((response) => {
        this.setState({ dep: response });
      })
      .catch((err) => console.log(err));

    fetch(myConstClass.BASE_URL + "user/get_all_positions/" + admin_id)
      .then((response) => response.json())
      .then((response) => {
        this.setState({ pos: response });
      })
      .catch((err) => console.log(err));
  }

  render() {
    var admin_id = localStorage.getItem("uname");
    var is_archived = localStorage.getItem("is_archived");
    const { emp } = this.state;
    const { pos, dep, org, org_emp } = this.state;
    let currTime = new Date().toLocaleString();
    //for export
    const csvColumns = this.csvColumns;
    const csvData = this.state.formData;
    let fileName = "Attendance_" + new Date().getTime() + ".csv";
    const minDate = new Date();
    minDate.setMonth(minDate.getMonth() - 6);

    let employee;
    if (org_emp != "") {
      employee = org_emp.map((cell, i) => {
        return (
          <option value={cell.id}>
            {cell.first_name} {cell.last_name}
          </option>
        );
      });
    }
    return (
      <Container fluid>
        <Header>
          <HeaderTitle>Attendance List</HeaderTitle>
          {/* <div  id="google_translate_element_1"></div><br/><br/> */}
          <Breadcrumb>
            <BreadcrumbItem>
              <Link to="/dashboard">Dashboard</Link>
            </BreadcrumbItem>
            {/* <BreadcrumbItem>
              <Link to="/dashboard">measures</Link>
            </BreadcrumbItem> */}
            <BreadcrumbItem active>Attendance List</BreadcrumbItem>
            {/* <button class="mr-1 mb-1 btn btn-outline-secondary" onClick={() =>this.edit(this.state.user_id)} style={{color:'#ffffff',border: '1px solid #ffffff',float:'right !important',margin:'auto'}}><Icon.PlusCircle />&nbsp;&nbsp;ADD</button> */}
            {admin_id != "0" ? (
              <button
                class="mr-1 mb-1 btn btn-outline-secondary"
                onClick={() => this.edit(this.state.user_id)}
                style={{
                  color: "#ffffff",
                  border: "1px solid #ffffff",
                  float: "right !important",
                  margin: "auto",
                }}
              >
                <Icon.PlusCircle />
                &nbsp;&nbsp;ADD
              </button>
            ) : (
              ""
            )}
          </Breadcrumb>
          {/* <span >ADD</span> */}
        </Header>

        <Card>
          {/* <AvForm id="sform">
         <Row className="f_class_present">
         <div class="col-md-3"></div>
          <div class="col-md-3"></div>
          <div class="col-md-1"></div>
              <div class="col-md-4">
                <AvGroup>
                  <Label for="example" className="search_title">Search</Label>
                  <AvInput name="search" className="search_present" onChange={this.search} type="text" id="example"/>
                </AvGroup>
              </div> <br/>
            </Row>
           </AvForm> */}
          <ToolkitProvider
            keyField="name"
            data={this.state.formData}
            columns={tableColumns}
            exportCSV
          >
            {(props) => (
              <div>
                <CardHeader>
                  {/* <div className="float-right pull-right">
                  
                    <MyExportCSV {...props.csvProps} /> */}
                  {/* <div class="float-right pull-right">
                      <CsvDownloader
                      className="csv"
                      filename={fileName}
                      columns={csvColumns}
                      datas={csvData}
                      text="Export" /></div> */}

                  {/* </div><br/> */}
                  {/* <CardTitle tag="h5">Export CSV</CardTitle>
                  <h6 className="card-subtitle text-muted">
                    Exportable CSV by react-bootstrap-table2
                  </h6> */}
                </CardHeader>
                <CardBody>
                  <AvForm id="sform"></AvForm>
                  <AvForm id="pform" onValidSubmit={this.handleValidSubmit}>
                    {/* With AvGroup AvInput and AvFeedback to build your own */}

                    {/* <button 
                      type="button"
                      onClick={this.handleSyncToHrm}
                      className="btn btn-primary sync_button "
                    >
                      Sync To HRM
                    </button> */}

                    <Row>
                      <div class="col-md-3">
                        <AvGroup>
                          <AvField
                            type="select"
                            name="organization_id"
                            label="Select Organization"
                            onChange={this.ochange}
                            value={this.state.organization_id}
                          >
                            <option value={0}>All Organization</option>
                            {org
                              ? org.map((cell, i) => {
                                  return (
                                    <option value={cell.id}>
                                      {cell.title}
                                    </option>
                                  );
                                })
                              : ""}
                          </AvField>
                        </AvGroup>
                      </div>
                      <div class="col-md-3">
                        <AvGroup>
                          {/* <AvInput name="employee_id" id="example" required value={formData ? formData.employee_id:''}/>
                  <AvFeedback>Enter Employee ID!</AvFeedback> */}
                          <AvField
                            type="select"
                            name="employee_id"
                            label="Select Employee"
                            onChange={this.change}
                            value={this.state.employee_id}
                          >
                            <option value="0">All Employees</option>
                            {emp
                              ? emp.map((cell, i) => {
                                  return (
                                    <option value={cell.id}>
                                      {cell.first_name} {cell.last_name}
                                    </option>
                                  );
                                })
                              : employee}
                          </AvField>
                        </AvGroup>
                      </div>
                      <div class="col-md-3">
                        <Label for="example">From Date </Label> <br />
                        <DatePicker
                          name="from_date"
                          selected={this.state.from_date}
                          onChange={this.handleFromDateChange}
                          dateFormat="dd-MM-yyyy"
                          className="is-untouched is-pristine av-valid form-control"
                          value={this.state.from_date}
                          minDate={minDate}
                          maxDate={moment().toDate()}
                        />
                      </div>
                      <br />

                      <div class="col-md-3">
                        {/* <AvGroup> */}
                        <Label for="example" >
                          To Date
                        </Label>{" "}
                        <br />
                        <DatePicker
                          name="to_date"
                          selected={this.state.to_date}
                          onChange={this.handleToDateChange}
                          dateFormat="dd-MM-yyyy"
                          // maxdate={this.state.maxdate}
                          className="is-untouched is-pristine av-valid form-control"
                          value={this.state.to_date}
                          minDate={minDate}
                          maxDate={moment().toDate()}
                        />
                      </div>
                      <div class="col-md-3">
                        <AvGroup>
                          <AvField
                            type="select"
                            name="department"
                            label="Select Department"
                            className="dep"
                            onChange={this.dep_change}
                            value={this.state.dep}
                          >
                            <option value={0}>All Departments</option>
                            {dep
                              ? dep.map((cell, i) => {
                                  return (
                                    <option value={cell.department}>
                                      {cell.department}
                                    </option>
                                  );
                                })
                              : ""}
                          </AvField>
                        </AvGroup>
                      </div>
                      <div class="col-md-3">
                        <AvGroup>
                          <AvField
                            type="select"
                            name="designation"
                            className="pos"
                            label="Select Position"
                            onChange={this.pos_change}
                            value={this.state.pos}
                          >
                            <option value={0}>All Positions</option>
                            {pos
                              ? pos.map((cell, i) => {
                                  return (
                                    <option value={cell.designation}>
                                      {cell.designation}
                                    </option>
                                  );
                                })
                              : ""}
                          </AvField>
                        </AvGroup>
                      </div>

                      <div class="col-md-3">
                        <AvGroup>
                          <Button
                            type="button"
                            name="apply_filter"
                            style={{ marginTop: "27px" }}
                            onClick={this.apply_filters}
                            disabled={this.state.disabled}
                          >
                            {this.state.disabled ? "Loading...." : "Apply"}
                          </Button>
                        </AvGroup>
                      </div>

                      {/* <div class="col-md-1"></div>
                   <div class="col-md-3">
                    <AvGroup>
                  <Label for="example" className="search_title">Search</Label>
                  <AvInput name="search" className="search_present" onChange={this.search} type="text" id="example"/>
                </AvGroup>
              </div> <br/> */}
                    </Row>
                    <br />

                    <Row>
                      {/* <MyExportCSV {...props.csvProps} /> */}
                      <div class="col-md-4">
                        <CSVLink
                          filename={"Attendance_" + moment() + ".csv"}
                          className="btn btn-secondary mt-2"
                          style={{ margin: "0rem 1.50rem 0rem 0rem" }}
                          disabled={this.state.export_disabled}
                          data={this.state.formDataCSV}
                          headers={headers}
                        >
                          {this.state.export_disabled
                            ? "Loading...."
                            : "Export"}
                        </CSVLink>
                        <button
                          className="btn btn-secondary mt-2"
                          style={
                            is_archived == "1"
                              ? { margin: "0rem 1.50rem 0rem 0rem" }
                              : { display: "none" }
                          }
                          onClick={() => this.archievedLeave()}
                        >
                          Archieved
                        </button>
                      </div>

                      <div class="col-md-4"></div>

                      <div class="col-md-4">
                        <AvGroup>
                          <Label for="example" className="search_title">
                            Search
                          </Label>
                          <AvInput
                            name="search"
                            className="search_present"
                            onChange={this.search}
                            type="text"
                            id="example"
                          />
                        </AvGroup>
                      </div>
                    </Row>
                    <Row>
                      <div class="col-md-3"></div>
                      <div class="col-md-3"></div>
                      <div class="col-md-1"></div>
                      <br />
                    </Row>
                  </AvForm>
                  <br />
                  <BootstrapTable
                    {...props.baseProps}
                    bootstrap4
                    bordered={false}
                    filter={filterFactory()}
                    filterPosition="top"
                    pagination={paginationFactory({
                      // sizePerPage: 25,
                      sizePerPage: 10,
                      sizePerPageList: [5, 10, 25, 50],
                    })}
                  />
                </CardBody>
              </div>
            )}
          </ToolkitProvider>
        </Card>

        {/* <ExportCSVTable /> */}
      </Container>
    );
  }
}

export default Attendance;
