import React,{ PureComponent } from "react";
import { Link } from "react-router-dom";
import * as myConstClass from '../../constant.js';
import DatePicker from "react-datepicker";
import "react-datepicker/dist/react-datepicker.css";
import filterFactory from 'react-bootstrap-table2-filter';
import './datepicker.scss';
import dateFormat from 'dateformat';
import cookie from "react-cookies";
// import CsvDownloader from 'react-csv-downloader';
import swal from 'sweetalert';
import { CSVLink } from "react-csv";
import moment from 'moment'
import {
  Breadcrumb,
  BreadcrumbItem, Button,Row,Label,
  Card,
  CardBody,
  CardHeader,
  Container
  ,
} from "reactstrap";

import Header from "../../components/Header";
import HeaderTitle from "../../components/HeaderTitle";
 
import BootstrapTable from "react-bootstrap-table-next";
import ToolkitProvider from "react-bootstrap-table2-toolkit";
import paginationFactory from "react-bootstrap-table2-paginator";
import { toastr } from "react-redux-toastr";
import * as Icon from "react-feather";
import 'react-confirm-alert/src/react-confirm-alert.css'; // Import css
import {
  AvForm,
  AvField,
  AvGroup,
  AvInput} from "availity-reactstrap-validation";


const headers = [
  { label: "Employee", key: "employee_id" },
  { label: "Attendance Date", key: "attendance_date" },
  { label: "In-Time - Out-Time", key: "clock_in" },
//   { label: "Total Work", key: "total_work" },
//   { label: "Timezone", key: "timezone" },
//   { label: "Check in Latitude Longitude", key: "checkin_lat" },
//   { label: "Check in Redius Check ", key: "checkout_radius_check" },
//   { label: "Check in Distance", key: "checkin_dist" },
//   { label: "Check iOut Latitude Longitude", key: "checkout_lat" },
//   { label: "Check Out Redius Check", key: "checkout_radius_check" },
//   { label: "Check Out Distance", key: "checkout_dist" },
//   { label: "Department", key: "department" },
//   { label: "Position", key: "designation" },
  { label: "Attendance Notes", key: "attendanceNotes" },
];

const tableColumns = [ 
  {
    dataField: "employee_id",
    text: "Employee",
    sort: true,
    headerStyle: { width:"10%" },
    // filter: textFilter()
  },
  {
    dataField: "attendance_date",
    text: "Attendance Date",
    sort: true,
    headerStyle: { width:"10%" },
    // filter: textFilter()
  },
  {
    dataField: "clock_in",
    text: "In-Time - Out-Time",
    sort: true,
    headerStyle: { width:"10%" },
    // filter: textFilter()
  },
  {
    dataField: "attendanceNotes",
    text: "Attendance Notes",
    sort: true,
    headerStyle: { width:"10%" },
    // filter: textFilter()
  },
  
];






  class Attendance extends PureComponent {
    constructor(props) {
      super(props);
      this.routeChange = this.routeChange.bind(this);
      //this.googleTranslateElementInit = this.googleTranslateElementInit.bind(this);
      this.state = {
        
        formData:[],
       
        googleTranslateElementInit:'',
       
        posts:'',
        timeOut: 5000,
        showCloseButton: true,
        progressBar: true,
        position: "top-right",
       
      }

      this.flag = 0;this.cid =0;this.oid =0;
     
      
      

    //   submitted: false,

    //for export
    this.csvColumns = [
      {
         displayName: "Employee", 
         id: "employee_id",
     },
      { displayName: 'Attendance Date',
      id: "attendance_date",
    },  
      { displayName: "In-Time", 
      id: "clock_in" },
      { displayName: "Out-Time", 
      id: "clock_out" },
      { displayName: "Timezone", 
      id: "timezone" },
    ];
    }

 

   

    routeChange() {
      this.props.history.push('/');
    }


   


   
    //  googleTranslateElementInit () {
    //   /* eslint-disable no-new */
    //   const google = window.google;
    //     new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element_1');
    //   new window.google.translate.TranslateElement({pageLanguage: 'pt', layout: window.google.translate.TranslateElement.FloatPosition.TOP_LEFT}, 'google_translate_element_1')
    // }

    
    componentDidMount(){
      this.setState({export_disabled: true});
  
      // window.googleTranslateElementInit = this.googleTranslateElementInit
      // const script = document.createElement("script");
      // script.src = "//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit";
      // script.async = true;
      // document.body.appendChild(script);  

      document.querySelector('.react-bootstrap-table').style.minHeight  = "243px";
      var admin_id= localStorage.getItem('uname'); 
      if(admin_id == null){
        this.routeChange();
      }
      var fdate = dateFormat(this.state.from_date,'yyyy-mm-dd');
      var tdate = dateFormat(this.state.to_date,'yyyy-mm-dd');

      if(this.pos_id == null || this.pos_id == ''){
        this.pos_id = 0;
      } else {
        this.pos_id =  this.pos_id;
      } 
      if(this.dep_id == null || this.dep_id == ''){
        this.dep_id = 0;
      } else {
        this.dep_id =  this.dep_id;
      }

     

      fetch(myConstClass.BASE_URL+'attendance/getAttendanceArchieved/'+admin_id)
      .then(response => response.json())
      .then(response =>{
        this.setState({formData: response})
      }).catch(err => console.log(err))


    
      fetch(myConstClass.BASE_URL+'attendance/getAttendanceArchieved/'+admin_id)    
      .then(response => response.json())
      .then(response =>this.setState({formDataCSV: response,export_disabled: false})).catch(err => console.log(err))

    
    }

      render() { 
        const {emp} = this.state;
        const {pos, dep, org} = this.state;
         //for export

        return(

 
      <Container fluid>
        <Header>  
          <HeaderTitle>Archieved Attendance List</HeaderTitle>
          <div  id="google_translate_element_1"></div><br/><br/>
          <Breadcrumb>
            <BreadcrumbItem>
              <Link to="/dashboard">Dashboard</Link>
            </BreadcrumbItem>
            {/* <BreadcrumbItem>
              <Link to="/dashboard">measures</Link>
            </BreadcrumbItem> */}
            <BreadcrumbItem active>
            <Link to="/attendance/listing">Attendance List</Link>

            </BreadcrumbItem>
            {/* <button class="mr-1 mb-1 btn btn-outline-secondary" onClick={() =>this.edit(this.state.user_id)} style={{color:'#ffffff',border: '1px solid #ffffff',float:'right !important',margin:'auto'}}><Icon.PlusCircle />&nbsp;&nbsp;ADD</button> */}
            
          </Breadcrumb>
          {/* <span >ADD</span> */}
        
        </Header>
       
        <Card>
        {/* <AvForm id="sform">
         <Row className="f_class_present">
         <div class="col-md-3"></div>
          <div class="col-md-3"></div>
          <div class="col-md-1"></div>
              <div class="col-md-4">
                <AvGroup>
                  <Label for="example" className="search_title">Search</Label>
                  <AvInput name="search" className="search_present" onChange={this.search} type="text" id="example"/>
                </AvGroup>
              </div> <br/>
            </Row>
           </AvForm> */}
          <ToolkitProvider
            keyField="name"
            data={this.state.formData}
            columns={tableColumns}
            exportCSV
          >
            
  
                 
            {props => (
              <div>
                <CardHeader>
                  {/* <div className="float-right pull-right">
                  
                    <MyExportCSV {...props.csvProps} /> */}
                    {/* <div class="float-right pull-right">
                      <CsvDownloader
                      className="csv"
                      filename={fileName}
                      columns={csvColumns}
                      datas={csvData}
                      text="Export" /></div> */}

                  {/* </div><br/> */}
                  {/* <CardTitle tag="h5">Export CSV</CardTitle>
                  <h6 className="card-subtitle text-muted">
                    Exportable CSV by react-bootstrap-table2
                  </h6> */}
                </CardHeader>
                <CardBody>
                <AvForm id="sform">
         <Row className="f_class_present">
         <div class="col-md-3"></div>
          <div class="col-md-3"></div>
          <div class="col-md-1"></div>
              <div class="col-md-4">
                {/* <AvGroup>
                  <Label for="example" className="search_title">Search</Label>
                  <AvInput name="search" className="search_present" onChange={this.search} type="text" id="example"/>
                </AvGroup> */}
              </div> 
              <br/>
            </Row>
           </AvForm>
                <AvForm id="pform" onValidSubmit={this.handleValidSubmit}>
               
               
  
               {/* With AvGroup AvInput and AvFeedback to build your own */}
             
             
               {/* <button 
                      type="button"
                      onClick={this.handleSyncToHrm}
                      className="btn btn-primary sync_button "
                    >
                      Sync To HRM
                    </button> */}
                  
        <br/>
         
           

           <Row>

          
           <div class="col-md-4">
           <Label for="example" className="search_title"></Label>
    
           {/* <MyExportCSV {...props.csvProps} /> */}
            <div class="col-md-4">
           <CSVLink filename={"Attendance_"+moment()+".csv"}
          className="btn btn-secondary" 
          disabled={this.state.export_disabled}      
          data={this.state.formData} headers={headers}>{this.state.export_disabled ? 'Loading....' : 'Export'}    </CSVLink>
        </div>
           </div>
             <div class="col-md-4"></div>
            </Row>
           </AvForm><br/>
                  <BootstrapTable
                    {...props.baseProps}
                    bootstrap4
                    bordered={false}
                    filter={filterFactory()}
                    filterPosition="top"
                    pagination={paginationFactory({
                      // sizePerPage: 25,
                      sizePerPage: 10,
                      sizePerPageList: [5, 10, 25, 50]
                    })}
                  />
                </CardBody>
              </div>
            )}
          </ToolkitProvider>
        </Card>
        
        {/* <ExportCSVTable /> */} 
      </Container>
        );
    }


}

export default Attendance;