import React, { PureComponent } from "react";
import { Link } from "react-router-dom";
import * as myConstClass from "../../constant.js";
import "react-datepicker/dist/react-datepicker.css";
import "./datepicker.scss";
import filterFactory from "react-bootstrap-table2-filter";
import Select from "react-select";
import {
  Breadcrumb,
  BreadcrumbItem,
  Button,
  Row,
  Col,
  Label,
  Card,
  CardBody,
  CardHeader,
  Container,
} from "reactstrap";

import Header from "../../components/Header";
import HeaderTitle from "../../components/HeaderTitle";
import { CSVLink } from "react-csv";
import moment from "moment";
import BootstrapTable from "react-bootstrap-table-next";
import ToolkitProvider, { Search } from "react-bootstrap-table2-toolkit";
import paginationFactory from "react-bootstrap-table2-paginator";
import { toastr } from "react-redux-toastr";
import * as Icon from "react-feather";
import "react-confirm-alert/src/react-confirm-alert.css"; // Import css
import swal from "sweetalert";
import { AvForm, AvGroup, AvInput } from "availity-reactstrap-validation";
const { SearchBar } = Search;
const statusOp = [
  { value: "0", label: "All" },
  { value: "1", label: "Active" },
  { value: "2", label: "In-Active" },
];
const headers = [
  {
    label: "Emp ID",
    key: "employee_id",
  },
  { label: "Name", key: "first_name" },
  { label: "Email", key: "email" },
  { label: "Mobile No", key: "mobile_no" },
  { label: "Position", key: "designation" },
  { label: "Department", key: "department" },
  { label: "Status", key: "status" },
  { label: "Employee Note", key: "employeeNotes" },
];

function imageFormatter(cell, row) {
  // alert(row.image);

  if (row.profile_image) {
    let file_lik;
    file_lik =
      myConstClass.BASE_URL + `/uploads/profile_img/` + row.profile_image;
    if (file_lik) {
      return (
        <span>
          <img
            class="img-thumbnail"
            style={{ height: "50px", width: "50px" }}
            src={file_lik}
          />
        </span>
      );
    } else {
      return (
        <span>
          <img
            class="img-thumbnail"
            src={myConstClass.BASE_URL + `img/profile.png`}
          />
        </span>
      );
    }
  } else {
    return (
      <span>
        <img
          class="img-thumbnail"
          src={myConstClass.BASE_URL + `img/profile.png`}
        />
      </span>
    );
  }
  //return "<img src='"+row.image+"'/>" ;
}
const tableColumns = [
  {
    //dataField: "first_name",
    text: "Profile Image",
    headerStyle: { width: "10%" },
    formatter: imageFormatter,
  },
  // {
  //   dataField: "employee_id",
  //   text: "Emp ID",
  //   sort: true,
  //   headerStyle: { width:"15%" }
  // },
  {
    dataField: "first_name",
    text: "Employee",
    sort: true,
    headerStyle: { width: "15%" },
    ref: "name1",
    // filter: textFilter(),
    // onFilter: ( filtered => {this.setState({ filtered })}),

    //...
    // }
    // onFilteredChange={filtered => {this.setState({ filtered });}}
  },
  {
    dataField: "email",
    text: "Email ",
    sort: true,
    headerStyle: { width: "25%" },
    // filter: textFilter()
  },
  {
    dataField: "mobile_no",
    text: "Mobile No",
    sort: true,
    headerStyle: { width: "11%" },
    // filter: textFilter()
  },

  {
    dataField: "organization_id",
    text: "Organization",
    sort: true,
    headerStyle: { width: "20%" },
    // filter: textFilter()
  },
  {
    dataField: "department",
    text: "Department",
    sort: true,
    headerStyle: { width: "15%" },
  },
  {
    dataField: "designation",
    text: "Position",
    sort: true,
    headerStyle: { width: "13%" },
  },

  // {
  //   dataField: "gender",
  //   text: "Gender",
  //   sort: true,
  //   headerStyle: { width:"12%" }

  // },
  // {
  //   dataField: "date_of_birth",
  //   text: "Date Of Birth",
  //   sort: true,
  //   headerStyle: { width:"10%" }

  // },
  // {
  //   dataField: "timezone",
  //   text: "Timezone",
  //   sort: true,
  //   headerStyle: { width:"10%" }

  // },
  {
    dataField: "status",
    text: "Status",
    headerStyle: { width: "15%" },
    // filter: textFilter()
  },
  {
    dataField: "action",
    text: "Action",
    headerStyle: { width: "15%" },
    csvExport: false,
  },
];
// console.log('-----------------'+JSON.stringify(tableColumns[0])+'-----------------');

const MyExportCSV = (props) => {
  const handleClick = () => {
    props.onExport();
  };
  return (
    <div>
      <button className="btn btn-secondary mt-2" onClick={handleClick}>
        Export
      </button>
    </div>
  );
};

class Employee extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      filtered: [],
    };

    this.routeChange = this.routeChange.bind(this);
    this.resetFilters = this.resetFilters.bind(this);
    // this.googleTranslateElementInit =
    //   this.googleTranslateElementInit.bind(this);

    this.state = {
      status: "1",
      designation: null,
      department: null,
      organization_id: null,
    };

    this.state = {
      user_id: 0,
      formData: [],
      dep: "",
      pos: "",
      countries: "",
      timeOut: 5000,
      showCloseButton: true,
      progressBar: true,
      position: "top-right",
    };
    this.change = this.change.bind(this);
    this.status_change = this.status_change.bind(this);
    this.search = this.search.bind(this);
    this.dep_change = this.dep_change.bind(this);
    this.pos_change = this.pos_change.bind(this);
    this.flag = 0;
    //this.sid = 1;
    this.cid = 0;
    this.pos_id = 0;
    this.dep_id = 0;
    //for export csv
    this.csvColumns = [
      {
        label: "Emp ID",
        id: "employee_id",
      },
      { label: "Name", id: "first_name" },
      { label: "Email", id: "email" },
      { label: "Mobile No", id: "mobile_no" },
      { label: "Position", id: "designation" },
      { label: "Department", id: "department" },
      { label: "Status", id: "status" },
      { label: "Employee Note", id: "employeeNotes" },
    ];
  }

  edit(e) {
    this.props.history.push("/employee/add/" + e);
  }

  // remove(e) {
  //   this.flag = 1;
  //   var admin_id = localStorage.getItem('uname');
  //   const options = {
  //       timeOut: parseInt(this.state.timeOut),
  //       showCloseButton: this.state.showCloseButton,
  //       progressBar: this.state.progressBar,
  //       position: this.state.position
  //     };
  //     this.flag = 1;
  //   confirmAlert({
  //     title: '',
  //     message: 'Are you sure ?',
  //     buttons: [
  //       {
  //         label: 'Yes',
  //         onClick: () =>    fetch(myConstClass.BASE_URL+`user/deleteUser`, {
  //           method: 'POST',
  //           body: e,
  //         }).then(toastr.success(
  //           'Success',
  //           "Employee Deleted Successfully..!",
  //           options
  //         ),
  //         fetch(myConstClass.BASE_URL+'user/getUsers/'+admin_id)
  //         .then(response => response.json())
  //         .then(response =>{
  //           let i=1;
  //           response.rows.forEach(element => {
  //           element.action = <div><i id={element.id} className="fa fa-remove ptr_css" onClick={() =>this.remove(element.id)}></i><i id={element.id} className="fa fa-edit ptr_css" onClick={() =>this.edit(element.id)}></i></div>;
  //            i++;
  //           });
  //           this.setState({posts: response})
  //         })
  //         .catch(err => console.log(err))
  //         )
  //         .catch()
  //       },
  //       {
  //         label: 'No',
  //         onClick: () => <Redirect to='/employee/listing'  />
  //       }
  //     ]
  //   });
  // }

  resetFilters = () => {
    var admin_id = localStorage.getItem("uname");
    fetch(myConstClass.BASE_URL + "user/getUsers/" + admin_id)
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          element.action = (
            <div>
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
  };

  remove(e) {
    var admin_id = localStorage.getItem("uname");

    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }

    swal({
      title: "Are you sure?",
      text: "Are you sure that you want to delete this record?",
      icon: "warning",
      // buttons: true,
      buttons: {
        confirm: {
          text: "OK",
          value: true,
          visible: true,
          className: "",
          closeModal: true,
        },
        cancel: {
          text: "Cancel",
          value: false,
          visible: true,
          className: "Custom_Cancel",
          closeModal: true,
        },
      },
      dangerMode: true,
    }).then((result) => {
      if (result) {
        const options = {
          timeOut: parseInt(this.state.timeOut),
          showCloseButton: this.state.showCloseButton,
          progressBar: this.state.progressBar,
          position: this.state.position,
        };
        this.flag = 1;
        fetch(myConstClass.BASE_URL + `/user/deleteUser/` + admin_id, {
          method: "POST",
          body: e,
        })
          .then(
            toastr.success(
              "Success",
              "Employee Deleted Successfully..!",
              options
            ),

            fetch(
              myConstClass.BASE_URL +
                "/user/getUsers/" +
                admin_id +
                "/" +
                this.cid +
                "/" +
                this.sid +
                "/" +
                this.pos_id +
                "/" +
                this.dep_id
            )
              .then((response) => response.json())
              .then((response) => {
                let i = 1;
                response.forEach((element) => {
                  let id = element.id;
                  element.action = (
                    <div>
                      <Icon.Edit3
                        style={{
                          margin: "0px 15px 0px 0px",
                          cursor: "Pointer",
                        }}
                        onClick={() => this.edit(id)}
                      />
                      {/* <Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/> */}
                    </div>
                  );
                  // console.log(element);
                  element.id = i;
                  i++;
                });
                this.setState({ formData: response });
              })
              .catch((err) => console.log(err))
          )
          .catch();
      }
    });
  }

  // change(event){
  change = (selectedOrg) => {
    this.setState({ selectedOrg });
    var admin_id = localStorage.getItem("uname");
    // this.cid = event.target.value;
    if (selectedOrg == null || selectedOrg == undefined) {
      this.cid = 0;
    } else {
      let x = Object.values(selectedOrg);
      // this.dep_id = event.target.value;
      this.cid = x[0];
    }
    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }

    fetch(
      myConstClass.BASE_URL +
        "/user/getUsers/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        this.sid +
        "/" +
        this.pos_id +
        "/" +
        this.dep_id
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          element.action = (
            <div>
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              {/* <Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/> */}
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
  };

  // status_change(e){
  status_change = (selectedStatus) => {
    this.setState({ selectedStatus });
    if (selectedStatus == null || selectedStatus == undefined) {
      this.sid = 0;
    } else {
      let x = Object.values(selectedStatus);
      // this.dep_id = event.target.value;
      this.sid = x[0];
    }

    var admin_id = localStorage.getItem("uname");
    // this.sid = event.target.value;

    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }

    fetch(
      myConstClass.BASE_URL +
        "/user/getUsers/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        this.sid +
        "/" +
        this.pos_id +
        "/" +
        this.dep_id
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          element.action = (
            <div>
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              {/* <Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/> */}
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
  };

  dep_change = (selectedDep) => {
    // dep_change(selectedDep){
    var admin_id = localStorage.getItem("uname");
    this.setState({ selectedDep });
    // this.dep_id = event.target.value;

    if (selectedDep == null || selectedDep == undefined) {
      this.dep_id = 0;
    } else {
      let x = Object.values(selectedDep);
      // this.dep_id = event.target.value;
      this.dep_id = x[0];
    }

    if (this.pos_id == null || this.pos_id == "") {
      this.pos_id = 0;
    } else {
      this.pos_id = this.pos_id;
    }
    fetch(
      myConstClass.BASE_URL +
        "/user/getUsers/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        this.sid +
        "/" +
        this.pos_id +
        "/" +
        this.dep_id
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          element.action = (
            <div>
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              {/* <Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/> */}
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
  };

  // pos_change(event){

  pos_change = (selectedPos) => {
    // dep_change(selectedDep){
    var admin_id = localStorage.getItem("uname");
    this.setState({ selectedPos });
    if (selectedPos == null || selectedPos == undefined) {
      this.pos_id = 0;
    } else {
      let x = Object.values(selectedPos);
      // this.dep_id = event.target.value;
      this.pos_id = x[0];
    }

    var admin_id = localStorage.getItem("uname");
    // this.pos_id = event.target.value;
    if (this.dep_id == null || this.dep_id == "") {
      this.dep_id = 0;
    } else {
      this.dep_id = this.dep_id;
    }
    fetch(
      myConstClass.BASE_URL +
        "/user/getUsers/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        this.sid +
        "/" +
        this.pos_id +
        "/" +
        this.dep_id
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          element.action = (
            <div>
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              {/* <Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/> */}
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
  };

  search(event) {
    var admin_id = localStorage.getItem("uname");
    this.sid = event.target.value;
    if (this.sid == null || this.sid == "") {
      this.sid = 0;
    } else {
      this.sid = event.target.value;
    }

    fetch(
      myConstClass.BASE_URL +
        "/user/getUsersOnSearch/" +
        admin_id +
        "/" +
        this.sid
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          element.action = (
            <div>
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              {/* <Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/> */}
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
  }

  routeChange() {
    this.props.history.push("/");
  }

  componentDidMount() {
    // var login_type = localStorage.getItem("login_type");
    // alert(login_type);
    // window.googleTranslateElementInit = this.googleTranslateElementInit;
    // const google = window.google;
    // const script = document.createElement("script");
    // script.src =
    //   "//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit";
    // script.async = true;
    // document.body.appendChild(script);
    if (this.sid == null || this.sid == "") {
      this.sid = 1;

      this.setState({ status: [{ value: "1", label: "Active" }] });
    } else {
      this.sid = this.sid;
    }
    document.querySelector(".react-bootstrap-table").style.minHeight = "243px";
    var admin_id = localStorage.getItem("uname");
    //alert(admin_id);
    if (admin_id == null) {
      this.routeChange();
    }
    // fetch(myConstClass.BASE_URL + "user/getUsers/" + admin_id)
    //   .then((response) => response.json())
    //   .then((response) => {
    //     let i = 1;
    //     response.forEach((element) => {
    //       let id = element.id;
    //       element.action = (
    //         <div>
    //           <Icon.Edit3
    //             style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
    //             onClick={() => this.edit(id)}
    //           />
    //           {/* <Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/> */}
    //         </div>
    //       );
    //       // console.log(element);
    //       element.id = i;
    //       i++;
    //     });
    //     this.setState({ formData: response });
    //   })
    //   .catch((err) => console.log(err));
    fetch(
      myConstClass.BASE_URL +
        "/user/getUsers/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        this.sid +
        "/" +
        this.pos_id +
        "/" +
        this.dep_id
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          element.action = (
            <div>
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              {/* <Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/> */}
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
    fetch(
      myConstClass.BASE_URL + "organization/get_all_organizations/" + admin_id
    )
      .then((response) => response.json())
      .then((response) => {
        response.forEach((element) => {
          //this.setState({ organization_id: element.id });
           if(admin_id!='0')
           {
          this.setState({ organization_id: [{ value: element.id, label: element.title }] });
           }
        });

        this.setState({ org: response });
      })
      .catch((err) => console.log(err));

    fetch(myConstClass.BASE_URL + "user/get_all_departments/" + admin_id)
      .then((response) => response.json())
      .then((response) => {
        this.setState({ dep: response });
      })
      .catch((err) => console.log(err));

    fetch(myConstClass.BASE_URL + "user/get_all_positions/" + admin_id)
      .then((response) => response.json())
      .then((response) => {
        this.setState({ pos: response });
      })
      .catch((err) => console.log(err));
  }

  // googleTranslateElementInit() {
  //   /* eslint-disable no-new */
  //   const google = window.google;
  //   new google.translate.TranslateElement(
  //     { pageLanguage: "en" },
  //     "google_translate_element"
  //   );
  //   new window.google.translate.TranslateElement(
  //     {
  //       pageLanguage: "pt",
  //       layout: window.google.translate.TranslateElement.FloatPosition.TOP_LEFT,
  //     },
  //     "google_translate_element"
  //   );
  // }

  render() {
    var admin_id = localStorage.getItem("uname");
    const { pos, dep, org, emp } = this.state;

    console.log();
    let orgOp = org
      ? org.map((cell, i) => {
          return { value: cell.id, label: cell.title };
        })
      : "";

    let posOp = pos
      ? pos.map((cell, i) => {
          return { value: cell.designation, label: cell.designation };
        })
      : "";
    let depOp = dep
      ? dep.map((cell, i) => {
          return { value: cell.department, label: cell.department };
        })
      : "";

    let import_btn;
    if (admin_id == 0) {
      import_btn = (
        <div>
          <Col lg={6}>
            <Link to="/employee_bulk_import/import/">
              {" "}
              <Button color="primary" type="button" className="import_btn">
                Import +
              </Button>
            </Link>
          </Col>
        </div>
      );
    } else {
      import_btn = "";
    }
    //for export csv
    const csvColumns = this.csvColumns;
    const csvData = this.state.formData;
    let fileName = "All_Employees_" + new Date().getTime() + ".csv";
    return (
      <Container fluid>
        <Header>
          {/* / <div id="google_translate_element"></div> */}
          <br />
          <HeaderTitle>Employees List</HeaderTitle>

          <Breadcrumb>
            <BreadcrumbItem>
              <Link to="/dashboard">Dashboard</Link>
            </BreadcrumbItem>
            {/* <BreadcrumbItem>
              <Link to="/dashboard">measures</Link>
            </BreadcrumbItem> */}
            <BreadcrumbItem active>Employees List</BreadcrumbItem>
            {/* <button class="mr-1 mb-1 btn btn-outline-secondary" onClick={() =>this.edit(this.state.user_id)} style={{color:'#ffffff',border: '1px solid #ffffff',float:'right !important',margin:'auto'}}><Icon.PlusCircle />&nbsp;&nbsp;ADD</button> */}
            {admin_id != "0" ? (
              <button
                class="mr-1 mb-1 btn btn-outline-secondary"
                onClick={() => this.edit(this.state.user_id)}
                style={{
                  color: "#ffffff",
                  border: "1px solid #ffffff",
                  float: "right !important",
                  margin: "auto",
                }}
              >
                <Icon.PlusCircle />
                &nbsp;&nbsp;ADD
              </button>
            ) : (
              ""
            )}
          </Breadcrumb>
          {/* <span >ADD</span> */}
        </Header>
        <Card>
          <Row>{import_btn}</Row>
          <AvForm id="sform">
            <Row>
              <div class="col-md-4"></div>
              <div class="col-md-4"></div>
              {/* <div class="col-md-4">
                <AvGroup>
                  <Label for="example" className="search_title">
                    Search
                  </Label>
                  <AvInput
                    name="search"
                    className="search_emp"
                    onChange={this.search}
                    type="text"
                    id="example"
                  />
                </AvGroup>
              </div> */}
            </Row>
          </AvForm>
          <br />
          <ToolkitProvider
            keyField="email"
            data={this.state.formData}
            columns={tableColumns}
            exportCSV
            search
          >
            {(props) => (
              <div>
                <CardHeader></CardHeader>
                <CardBody>
                  <AvForm id="pform" onValidSubmit={this.handleValidSubmit}>
                    {/* With AvGroup AvInput and AvFeedback to build your own */}
                    <Row>
                      <div class="col-md-4">
                        <AvGroup>
                          <label>Select Organization</label>
                          <Select
                            value={this.state.organization_id}
                            name="organization_id"
                            onChange={this.change}
                            options={orgOp}
                            isClearable
                            placeholder="Select Organization"
                          />
                        </AvGroup>
                      </div>
                      <div class="col-md-4">
                        <Label for="example">Status</Label>
                        <Select
                          value={this.state.status}
                          name="status"
                          onChange={this.status_change}
                          options={statusOp}
                          isClearable
                          placeholder="Select Status"
                        />
                        <AvGroup></AvGroup>
                      </div>
                    </Row>
                    <br />
                    <br />
                    <br />
                    <Row className="c_row">
                      <div class="col-md-4">
                        <AvGroup>
                          <label>Select Department</label>
                          <Select
                            value={this.state.department}
                            name="department"
                            onChange={this.dep_change}
                            options={depOp}
                            isClearable
                            placeholder="Select Department"
                          />
                        </AvGroup>
                      </div>
                      <div class="col-md-4">
                        <AvGroup>
                          <label>Select Positions</label>
                          <Select
                            value={this.state.designation}
                            name="designation"
                            onChange={this.pos_change}
                            options={posOp}
                            isClearable
                            placeholder="Select Positions"
                          />
                        </AvGroup>
                      </div>
                    </Row>
                    <Row>
                      <div class="col-md-4">
                        {/* <Label for="example" className="search_title"></Label>
           <MyExportCSV {...props.csvProps} /> */}
                        <CSVLink
                          filename={"Employee_" + moment() + ".csv"}
                          className="btn btn-secondary"
                          //disabled={this.state.export_disabled}
                          data={this.state.formData}
                          headers={headers}
                        >
                          {this.state.export_disabled
                            ? "Loading...."
                            : "Export"}{" "}
                        </CSVLink>
                      </div>
                      <div class="col-md-4"></div>
                      <div>
                        <Label for="example"> </Label>
                        <SearchBar
                          {...props.searchProps}
                          placeholder="Search"
                        />
                      </div>
                    </Row>
                  </AvForm>
                  <br />
                  <BootstrapTable
                    {...props.baseProps}
                    bootstrap4
                    bordered={false}
                    filter={filterFactory()}
                    filterPosition="top"
                    // onFilteredChange={filtered => {this.setState({ filtered });}}
                    pagination={paginationFactory({
                      // sizePerPage: 25,
                      sizePerPage: 10,
                      sizePerPageList: [5, 10, 25, 50],
                    })}
                  />
                </CardBody>
              </div>
            )}
          </ToolkitProvider>
        </Card>

        {/* <ExportCSVTable /> */}
      </Container>
    );
  }
}

export default Employee;
