import React, { PureComponent } from "react";
import { Link } from "react-router-dom";
import DatePicker from "react-datepicker";
import ReactCrop, { makeAspectCrop } from "react-image-crop";
import "react-datepicker/dist/react-datepicker.css";
import "./datepicker.scss";
import dateFormat from "dateformat";
import "react-image-crop/dist/ReactCrop.css";
// import { Link } from "react-router-dom";
import Select from "react-select";
import BootstrapTable from "react-bootstrap-table-next";
import ToolkitProvider from "react-bootstrap-table2-toolkit";
import paginationFactory from "react-bootstrap-table2-paginator";
import App from "./App";
import {
  Breadcrumb,
  BreadcrumbItem,
  Row,
  Col,
  Card,
  Input,
  CardBody,
  Container,
  Button,
  Label,
  FormGroup,
  Modal,
  ModalBody,
  ModalFooter,
  ModalHeader,
} from "reactstrap";

import Header from "../../components/Header";
import HeaderTitle from "../../components/HeaderTitle";

import * as myConstClass from "../../constant.js";
import $ from "jquery";
import { toastr } from "react-redux-toastr";
import * as Icon from "react-feather";
import {
  AvForm,
  AvGroup,
  AvInput,
  AvFeedback,
  AvField,
} from "availity-reactstrap-validation";

const statusOp = [
  { value: "1", label: "Active" },
  { value: "2", label: "In-Active" },
];
const restrictCheckinOp = [
  { value: "1", label: "No" },
  { value: "0", label: "Yes" },
];
const restrictCheckOutOp = [
  { value: "1", label: "No" },
  { value: "0", label: "Yes" },
];
const genderOp = [
  { value: "1", label: "Male" },
  { value: "2", label: "Female" },
  // { value: "3", label: "Other" },
];

const residentOp = [
  { value: "1", label: "Resident" },
  { value: "0", label: "Non-Resident" },
];

const deprOp = [
  { value: "1", label: "Spouse" },
  { value: "2", label: "Child" },
];

const depStatusOp = [
  { value: "1", label: "Active" },
  { value: "2", label: "In-Active" },
];

const tableColumns = [
  {
    dataField: "dependant_name",
    text: "Dependant Name",
    sort: true,
    headerStyle: { width: "25%" },
    // filter: textFilter()
  },
  {
    dataField: "relation",
    text: "Relation",
    sort: true,
    headerStyle: { width: "15%" },
  },
  {
    dataField: "dependant_date_of_birth",
    text: "Date Of Birth ",
    sort: true,
    headerStyle: { width: "25%" },
    // filter: textFilter()
  },
  {
    dataField: "dependant_status",
    text: "Status",
    sort: true,
    headerStyle: { width: "25%" },
    // filter: textFilter()
  },
  {
    dataField: "dependentNotes",
    text: "Dependant Notes",
    sort: true,
    headerStyle: { width: "25%" },
    // filter: textFilter()
  },
  {
    dataField: "action",
    text: "Action",
    headerStyle: { width: "15%" },
    csvExport: false,
  },
];

class Validation extends PureComponent {
  constructor(props) {
    super(props);
    this.changeRadioRestrictIn = this.changeRadioRestrictIn.bind(this);
    this.routeChange = this.routeChange.bind(this);
    // this.googleTranslateElementInit =
    //   this.googleTranslateElementInit.bind(this);
    this.handleValidSubmitDepandant =
      this.handleValidSubmitDepandant.bind(this);
    this.handleDateChange = this.handleDateChange.bind(this);
    this.handleUpdateDepandant = this.handleUpdateDepandant.bind(this);
    this.state = {
      file_link_profile: "",
      uploadphoto: false,
      takephoto: false,
      status: null,
      check_in_radius: null,
      check_out_radius: null,
      organization_id: null,
      timezone: null,
      nationality: null,
      gender: null,
      resident: null,
      relation: null,
      dependant_status: null,
    };
    this.state = {
      shiftData:'',
      user_id: "0",
      units: "",
      org: "",
      dep: "",
      startDate: new Date(),
      timezones: "",
      nationality: "",
      resident: "",
      relation: "",
      groups: "",
      // status:'',
      hradmin: "",
      dependant_status: "",
      formData_dependant: {},
      formData_dependant_e: {},
      employee_group: [],
      formData: {
        employee_shift:'',
        restrict_checkin_radius: "",
        checkedRadioout: false,
        employee_id: "",
        name: "",
        email: "",
        mobile_no: "",
        gender: "",
        position: "",
        department: "",
        status: "",
        check_in_radius: "",
        check_out_radius: "",
        date_of_birth: "",
        date_of_birth_dep: "",
        dependant_date_of_birth: "",
        organization_id: "",
        timezone: "",
        nationality: "",
        resident: "",
        countries: "",
        relation: "",
      },
      submitted: false,
      timeOut: 5000,
      showCloseButton: true,
      progressBar: true,
      position: "top-right",
    };

    this.options = {
      timeOut: parseInt(this.state.timeOut),
      showCloseButton: this.state.showCloseButton,
      progressBar: this.state.progressBar,
      position: this.state.position,
    };
  }

  state = {
    crop: {
      x: 20,
      y: 10,
      width: 100,
      aspect: 1,
    },
    showCroppedImage: false,
    croppedImage: null,
  };
  status = (selectedStatus) => {
    this.setState({ status: selectedStatus });
  };
  check_in_radius = (selectedRestrictionCheckin) => {
    this.setState({ check_in_radius: selectedRestrictionCheckin });
  };
  check_out_radius = (selectedRestrictionCheckOut) => {
    this.setState({ check_out_radius: selectedRestrictionCheckOut });
  };

  organization_id = (selectedOrg) => {
    this.setState({ organization_id: selectedOrg });
  };

  timezone = (selectedTimezone) => {
    this.setState({ timezone: selectedTimezone });
  };
  gender = (selectedGender) => {
    this.setState({ gender: selectedGender });
  };
  nationality = (selectedNationality) => {
    this.setState({ nationality: selectedNationality });
  };
  resident = (selectedResident) => {
    this.setState({ resident: selectedResident });
  };
  relation = (selectedRelation) => {
    this.setState({ relation: selectedRelation });
  };
  dependant_status = (selectedDependantStatus) => {
    this.setState({ dependant_status: selectedDependantStatus });
  };
  handleGroupChange = (group) => {
    this.setState({ employee_group: group });
  };

  toggle = (open_mod) => {
    this.setState((state) => ({
      [open_mod]: !state[open_mod],
    }));
  };

  toggleEdit = (open_mod) => {
    this.state.id = open_mod;
    this.setState((state) => ({
      [open_mod]: !state[open_mod],
    }));

    fetch(myConstClass.BASE_URL + "user/getDependantInfo90/" + open_mod)
      .then((response) => response.json())
      .then((response) => {
        if (response.relation == 1) {
          this.setState({ relation: [{ value: "1", label: "Spouse" }] });
        } else if (response.relation == 2) {
          this.setState({ relation: [{ value: "2", label: "Child" }] });
        }
        if (response.dependant_status == 1) {
          this.setState({
            dependant_status: [{ value: "1", label: "active" }],
          });
        } else if (response.dependant_status == 2) {
          this.setState({
            dependant_status: [{ value: "2", label: "In-Active" }],
          });
        }

        this.setState({ formData_dependant_e: response });
      })
      .catch((err) => console.log(err));
  };

  clearFilters() {
    this.setState({
      status: null,
    });
  }

  handleClick = (e) => {
    const target = e.currentTarget;

    if (
      target.checked &&
      this.state[`${target.name}-${target.value}`] === target.checked
    ) {
      target.checked = false;
      target.click();
    }
  };

  handleClickEdit = (e) => {
    const target = e.currentTarget;

    if (
      target.checked &&
      this.state[`${target.name}-${target.value}`] === target.checked
    ) {
      target.checked = false;
      target.click();
    }
  };

  handleChangeRadioEdit = (e) => {
    const target = e.target;
    if (this.state[`${target.name}-${target.value}`] !== target.checked) {
      this.setState({
        [`${target.name}-${target.value}`]: target.unchecked,
      });
    }
  };

  handleChangeRadio = (e) => {
    const target = e.target;

    if (this.state[`${target.name}-${target.value}`] !== target.checked) {
      this.setState({
        [`${target.name}-${target.value}`]: target.checked,
      });
    }
  };

  changeRadioRestrictIn(e) {
    if (e.target.checked && !this.state.checkedRadioIn) {
      this.setState({
        checkedRadioIn: true,
      });
    } else if (e.target.checked && this.state.checkedRadioIn) {
      this.setState({
        checkedRadioIn: false,
      });

      // this.setState({ checkedRadioIn: e.target.value });
    }
  }

  edit(e) {
    fetch(myConstClass.BASE_URL + "user/getDependantInfo/" + e)
      .then((response) => response.json())
      .then((response) => {
        if (response.relation == 1) {
          this.setState({ relation: [{ value: "1", label: "Spouse" }] });
        } else if (response.relation == 0) {
          this.setState({ relation: [{ value: "2", label: "Child" }] });
        }

        let i = 1;
        response.forEach((element) => {
          let id = element.id;
          element.action = (
            <div>
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          // console.log(element);
          element.id = i;
          i++;
        });
        this.setState({ formData_dependant: response });
      })
      .catch((err) => console.log(err));
  }

  routeChange() {
    this.props.history.push("/");
  }
  componentDidMount() {
    // const { status} = this.state;
    // const restrict_checkin_radius= this.state.restrict_checkin_radius;
    // window.googleTranslateElementInit = this.googleTranslateElementInit;
    // const google = window.google;
    // const script = document.createElement("script");
    // script.src =
    //   "//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit";
    // script.async = true;
    // document.body.appendChild(script);

    var admin_id = localStorage.getItem("uname");
    if (admin_id == null) {
      this.routeChange();
    }
    var admin_id = localStorage.getItem("uname");
    const answer_array = this.props.location.pathname.split("/");

    if (answer_array["3"]) {
      this.state.user_id = answer_array["3"];
      fetch(myConstClass.BASE_URL + "user/getUserInfoE/" + answer_array["3"])
        .then((response) => response.json())
        .then((response) => {
          this.setState({
            file_link_profile: myConstClass.BASE_URL + `img/profile.png`,
          });

          if (response.status == 1) {
            this.setState({ status: [{ value: "1", label: "Active" }] });
          } else if (response.status == 2) {
            this.setState({ status: [{ value: "2", label: "In-Active" }] });
          } else {
            this.setState({ status: [{ value: "1", label: "Active" }] });
          }

          if (response.restrict_checkin_radius == 1) {
            this.setState({ check_in_radius: [{ value: "1", label: "No" }] });
          } else if (response.restrict_checkin_radius == 0) {
            this.setState({ check_in_radius: [{ value: "0", label: "Yes" }] });
          } else {
            this.setState({ check_in_radius: [{ value: "1", label: "No" }] });
          }

          if (response.restrict_checkout_radius == 1) {
            this.setState({ check_out_radius: [{ value: "1", label: "No" }] });
          } else if (response.restrict_checkout_radius == 0) {
            this.setState({ check_out_radius: [{ value: "0", label: "Yes" }] });
          } else {
            this.setState({ check_out_radius: [{ value: "1", label: "No" }] });
          }

          if (response.is_resident == 1) {
            this.setState({ resident: [{ value: "1", label: "Resident" }] });
          } else if (response.is_resident == 0) {
            this.setState({
              resident: [{ value: "0", label: "Non-Resident" }],
            });
          } else {
            this.setState({ resident: [{ value: "1", label: "Resident" }] });
          }

          if (response.gender == 1) {
            this.setState({ gender: [{ value: "1", label: "Male" }] });
          } else if (response.gender == 2) {
            this.setState({ gender: [{ value: "2", label: "Female" }] });
          } else if (response.gender == 3) {
            this.setState({ gender: [{ value: "3", label: "Other" }] });
          } else {
            this.setState({ gender: [{ value: "1", label: "Male" }] });
          }

          this.setState({
            organization_id: [
              { value: response.organization_id, label: response.title },
            ],
          });

          this.setState({
            employee_group: [
              { value: response.employee_group, label: response.group_title },
            ],
          });

          if (response.timezone) {
            this.setState({
              timezone: [
                {
                  value: response.timezone,
                  label:
                    response.timezone + "(UTC " + response.UTC_offset + ")",
                },
              ],
            });
          } else {
            this.setState({
              timezone: [
                {
                  value: "Asia/Phnom_Penh",
                  label: "Asia/Phnom_Penh (UTC +07:00)",
                },
              ],
            });
          }
          if (response.nationality) {
            this.setState({
              nationality: [
                { value: response.nationality, label: response.country_name },
              ],
            });
          } else {
            this.setState({
              nationality: [{ value: "36", label: "Combidia" }],
            });
          }

          // this.setState({ nationality: selectedNationality });

          this.setState({ formData: response });
        })
        .catch((err) => console.log(err));

      fetch(
        myConstClass.BASE_URL +
          "user/getHrAdminInfo/" +
          answer_array["3"] +
          "/" +
          admin_id
      )
        .then((response) => response.json())
        .then((response) => {
          this.setState({ hradmin: response });
        })
        .catch((err) => console.log(err));

      fetch(
        myConstClass.BASE_URL +
          "user/generateQRCode/" +
          answer_array["3"] +
          "/" +
          admin_id
      )
        .then((response) => response.json())
        .then((response) => {
          this.setState({ hradmin: response });
        })
        .catch((err) => console.log(err));

      fetch(
        myConstClass.BASE_URL + "user/get_all_dependant/" + answer_array["3"]
      )
        .then((response) => response.json())
        .then((response) => {
          let i = 1;
          response.forEach((element) => {
            let id = element.id;
            //  = id;
            element.action = (
              <div>
                <Icon.Edit3
                  style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                  onClick={() => this.toggleEdit(id)}
                />
              </div>
            );
            // console.log(element);
            element.id = i;
            i++;
          });
          this.setState({ formData_dependant: response });
        })
        .catch((err) => console.log(err));

      // .then(response =>{this.setState({formData_depend: response}) }).catch(err => console.log(err))
    }

   

    fetch(
      myConstClass.BASE_URL + "organization/get_all_organizations/" + admin_id
    )
      .then((response) => response.json())
      .then((response) => {
        this.setState({ org: response });
      })
      .catch((err) => console.log(err));

    fetch(myConstClass.BASE_URL + "user/get_all_timezones/")
      .then((response) => response.json())
      .then((response) => {
        this.setState({ timezones: response });
      })
      .catch((err) => console.log(err));

    fetch(myConstClass.BASE_URL + "user/get_all_countries/" + admin_id)
      .then((response) => response.json())
      .then((response) => {
        this.setState({ countries: response });
      })
      .catch((err) => console.log(err));

    fetch(myConstClass.BASE_URL + "user/get_all_emp_groups/" + admin_id)
      .then((response) => response.json())
      .then((response) => {
        this.setState({ groups: response });
      })
      .catch((err) => console.log(err));



      fetch(
        myConstClass.BASE_URL + "shifts/getshifts/" + admin_id + "/" + 0+ "/" + 0+ "/" + 0
      )
        .then((response) => response.json())
        .then((response) => {
         
          this.setState({ shiftData: response });
        })
        .catch((err) => console.log(err));
  }

  download_qr_code(e) {
    const { formData } = this.state;
    // window.location.href = 'http://localhost/workzone/workzone/backend/uploads/qr_codes/'+formData.qr_code_img+'.pdf'

    var element = document.createElement("a");
    var file = new Blob(
      [
        "http://localhost/workzone/workzone/backend/uploads/qr_codes/" +
          formData.qr_code_img,
      ],
      { type: "image/*" }
    );
    element.href = URL.createObjectURL(file);
    element.download = "image.jpg";
    element.click();

    // $.ajax({
    //   url: myConstClass.BASE_URL+'user/download_qr_code/'+e,
    //   cache: false,
    //   success: function(data) {

    //   }
    // });

    // fetch(myConstClass.BASE_URL+'user/download_qr_code/'+e)
    // .then(response => response.json())
    // .then(response =>{this.setState({response: response}) }).catch(err => console.log(err))
  }

  googleTranslateElementInit() {
    /* eslint-disable no-new */
    const google = window.google;
    new google.translate.TranslateElement(
      { pageLanguage: "en" },
      "google_translate_element_empval"
    );
    new window.google.translate.TranslateElement(
      {
        pageLanguage: "pt",
        layout: window.google.translate.TranslateElement.FloatPosition.TOP_LEFT,
      },
      "google_translate_element_empval"
    );
  }

  handleChange = (date_of_birth) => {
    this.setState({ date_of_birth });
  };
  handleDateChange = (dependant_date_of_birth) => {
    //alert(date_of_birth_dep);
    this.setState({ dependant_date_of_birth });
  };

  // handleChange = date => {
  //   this.setState({
  //     startDate: date
  //   });
  // };

  handleUpdateDepandant = () => {
    var admin_id = localStorage.getItem("uname");

    setTimeout(() => this.setState({ submitted: false }), 5000);
    fetch(
      myConstClass.BASE_URL +
        `user/edit_dependant/` +
        admin_id +
        "/" +
        this.state.id,
      {
        method: "POST",
        body: JSON.stringify($("#edform").serializeArray()),
      }
    )
      .then((response) => response.json())
      .then((response) => {
        if (response == true) {
          this.state.user_id == "0"
            ? toastr.success(
                "Success",
                "Dependant Added Successfully..!",
                this.options
              )
            : toastr.success(
                "Success",
                "Dependant Updated Successfully..!",
                this.options
              );

          // this.props.history.push('/employee/listing');
          this.toggle(this.state.id);
          fetch(
            myConstClass.BASE_URL +
              "user/get_all_dependant/" +
              this.state.user_id
          )
            .then((response) => response.json())
            .then((response) => {
              let i = 1;
              response.forEach((element) => {
                let id = element.id;
                //  = id;
                element.action = (
                  <div>
                    <Icon.Edit3
                      style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                      onClick={() => this.toggleEdit(id)}
                    />
                  </div>
                );
                // console.log(element);
                element.id = i;
                i++;
              });
              this.setState({ formData_dependant: response });
            })
            .catch((err) => console.log(err));
        } else if (response == 4) {
          toastr.error(
            "Error",
            "Please enter a valid Mobile Number",
            this.options
          );
        } else {
          toastr.error("Error", "Can not Add Dependant ..!", this.options);
        }
      })
      .catch();
  };

  handleValidSubmitDepandant = () => {
    var admin_id = localStorage.getItem("uname");

    setTimeout(() => this.setState({ submitted: false }), 5000);
    fetch(
      myConstClass.BASE_URL +
        `user/add_dependant/` +
        admin_id +
        "/" +
        this.state.user_id,
      {
        method: "POST",
        body: JSON.stringify($("#dform").serializeArray()),
      }
    )
      .then((response) => response.json())
      .then((response) => {
        if (response == true) {
          this.state.user_id == "0"
            ? toastr.success(
                "Success",
                "Dependant Added Successfully..!",
                this.options
              )
            : toastr.success(
                "Success",
                "Dependant Updated Successfully..!",
                this.options
              );

          // this.props.history.push('/employee/listing');
          this.toggle(this.state.user_id);
          fetch(
            myConstClass.BASE_URL +
              "user/get_all_dependant/" +
              this.state.user_id
          )
            .then((response) => response.json())
            .then((response) => {
              let i = 1;
              response.forEach((element) => {
                let id = element.id;
                //  = id;
                element.action = (
                  <div>
                    <Icon.Edit3
                      style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                      onClick={() => this.toggleEdit(id)}
                    />
                  </div>
                );
                // console.log(element);
                element.id = i;
                i++;
              });
              this.setState({ formData_dependant: response });
            })
            .catch((err) => console.log(err));
        } else if (response == 4) {
          toastr.error(
            "Error",
            "Please enter a valid Mobile Number",
            this.options
          );
        } else {
          toastr.error("Error", "Can not Add Dependant ..!", this.options);
        }
      })
      .catch();
  };

  handleValidSubmit = () => {
    var admin_id = localStorage.getItem("uname");

    const original_src = document.getElementById("original_src");
    const cropped_imgsrc = document.getElementById("cropped_img");

    const data = new FormData();
    if (this.state.takephoto == true) {
      // var cropped_imgsrc = document.getElementById("cropped_img").src;
      // var normal_imgsrc = document.getElementById("normal_img").src;
      //alert(document.getElementById("normal_imgsrc").src);
      if (original_src) {
        data.append("content", document.getElementById("original_src").src);
      }
      if (cropped_imgsrc) {
        data.append("content", document.getElementById("cropped_img").src);
      }

      // else
      // {
      //   i++;
      //   //return;
      //   // this.setState({ submitted: true });
      // }
    } else {
      data.append("file", this.state.blobFile);
    }

    data.append("formdata", JSON.stringify($("#pform").serializeArray()));

    this.setState({ submitted: true }, () => {
      setTimeout(() => this.setState({ submitted: false }), 5000);
      fetch(
        myConstClass.BASE_URL +
          `user/add/` +
          admin_id +
          "/" +
          this.state.user_id,
        {
          method: "POST",
          body: data,
          // body: JSON.stringify($('#pform').serializeArray()),
        }
      )
        .then((response) => response.json())
        .then((response) => {
          if (response == true) {
            this.state.user_id == "0"
              ? toastr.success(
                  "Success",
                  "Employee Added Successfully..!",
                  this.options
                )
              : toastr.success(
                  "Success",
                  "Employee Updated Successfully..!",
                  this.options
                );

            this.props.history.push("/employee/listing");
          } else if (response == 4) {
            toastr.error(
              "Error",
              "Please enter a valid Mobile Number",
              this.options
            );
          } else if (response == 2) {
            toastr.error("Error", "Email Already Exists..!", this.options);
          } else if (response == 3) {
            toastr.error(
              "Error",
              "Employee ID Already Exists..!",
              this.options
            );
          } else if (response == 7) {
            toastr.error(
              "Error",
              "Please fill the Lat-Long details..!",
              this.options
            );
          } else {
            toastr.error("Error", "Can not Add Employee ..!", this.options);
          }
        })
        .catch();
    });
  };
  onSelectFile = (e) => {
    if (e.target.files && e.target.files.length > 0) {
      const reader = new FileReader();
      let file = e.target.files[0];
      //this.setState({ file_link_profile:file });
      reader.onloadend = () => {
        this.setState({
          file_link_profile: reader.result,
          blobFile: file,
          // imagePreviewUrl: reader.result
        });
      };
      reader.addEventListener(
        "load",
        () => this.setState({ srcrop: reader.result })

        // $("#preimg").attr("src", reader.result)
      );

      reader.readAsDataURL(e.target.files[0]);

      //  alert(reader.file_link_profile);
      // this.setState({ srcp: reader.result })
    }
  };

  // If you setState the crop in here you should return false.
  onImageLoaded = (image) => {
    this.imageRef = image;
  };

  onCropComplete = (crop) => {
    this.makeClientCrop(crop);
  };

  onCropChange = (crop) => {
    // You could also use percentCrop:
    // this.setState({ crop: percentCrop });
    this.setState({ crop });
  };

  async makeClientCrop(crop) {
    if (this.imageRef && crop.width && crop.height) {
      const croppedImageUrl = await this.getCroppedImg(
        this.imageRef,
        crop,
        "newFile.jpeg"
      );
      this.setState({ croppedImageUrl });
      $("#preimg").attr("src", croppedImageUrl);
      // alert(croppedImageUrl);
    }
  }

  getCroppedImg(image, crop, fileName) {
    const canvas = document.createElement("canvas");
    const scaleX = image.naturalWidth / image.width;
    const scaleY = image.naturalHeight / image.height;
    canvas.width = crop.width;
    canvas.height = crop.height;
    const ctx = canvas.getContext("2d");

    ctx.drawImage(
      image,
      crop.x * scaleX,
      crop.y * scaleY,
      crop.width * scaleX,
      crop.height * scaleY,
      0,
      0,
      crop.width,
      crop.height
    );

    //         var img = document.getElementById("preimg");
    // ctx.drawImage(img, 0, 0);

    return new Promise((resolve) => {
      canvas.toBlob((blob) => {
        if (!blob) {
          //reject(new Error('Canvas is empty'));
          console.error("Canvas is empty");
          return;
        }

        window.URL.revokeObjectURL(this.fileUrl);
        this.fileUrl = window.URL.createObjectURL(blob);
        blob.name = fileName;
        this.setState({ blobFile: blob });
        this.setState({ imagePreviewUrl: blob });
        resolve(this.fileUrl);
      }, "image/jpeg");
    });
  }

  uploadphoto = () => {
    this.setState({ uploadphoto: true });
    this.setState({ up: true });
    this.setState({ tp: false });
    this.setState({ takephoto: false });
    //this.setState({uploadedimage:false});
    this.setState({ enable: true });
    //this.setState({'this.setState({uploadedimage:true});':true});
  };

  takephoto = () => {
    this.setState({ submitted: false });
    this.setState({ uploadphoto: false });
    this.setState({ tp: true });
    this.setState({ up: false });
    this.setState({ takephoto: true });
    //this.setState({uploadedimage:false});
    this.setState({ enable: true });
  };
  changeOrganization = (event) => {
   // alert(event.target.value);
    fetch(myConstClass.BASE_URL + "shifts/getShiftsByOrg/" + event.target.value)
    .then((response) => response.json())
    .then((response) => {
      this.setState({ shifts: response });
    })
    .catch((err) => console.log(err));
  };
  render() {
    const { formData_dependant_e, formData, srcrop, submitted, groups, crop,shiftData } =
      this.state;
    const statusOp = [
      { value: "1", label: "Active" },
      { value: "2", label: "In-Active" },
    ];

    const download = () => {
      const url = window.URL.createObjectURL(
        new Blob([
          "http://localhost/workzone/workzone/backend/uploads/qr_codes/" +
            formData.qr_code_img,
        ])
      );
      const link = document.createElement("a");
      link.href = url;
      link.setAttribute("download", "image.png"); //or any other extension
      document.body.appendChild(link);
      link.click();

      // var element = document.createElement("a");
      // var file = new Blob(
      //   [
      //     'http://localhost/workzone/workzone/backend/uploads/qr_codes/'+formData.qr_code_img
      //   ],
      //   { type: "image/*" }
      // );
      // element.href = URL.createObjectURL(file);
      // element.download = "image.png";
      // element.click();
    };

    const {
      employee_group,
      dependant_status,
      formData_dependant,
      org,
      timezones,
      hradmin,
      status,
      check_in_radius,
      check_out_radius,
      organization_id,
      timezone,
      gender,
      countries,
      nationality,
      resident,
      relation,
    } = this.state;
    let orgOp = org
      ? org.map((cell, i) => {
          return { value: cell.id, label: cell.title };
        })
      : "";

    let timezoneOp = timezones
      ? timezones.map((cell, i) => {
          return {
            value: cell.TimeZone,
            label: cell.TimeZone + "(UTC " + cell.UTC_offset + ")",
          };
          // return( value: cell.TimeZone, label: cell.TimeZone+'(UTC '+cell.UTC_offset+')' }
        })
      : "";

    let natinalityOp = countries
      ? countries.map((cell, i) => {
          return { value: cell.country_id, label: cell.country_name };
          // return( value: cell.TimeZone, label: cell.TimeZone+'(UTC '+cell.UTC_offset+')' }
        })
      : "";

    // this.setState({timezone:[{ value:'Asia/Phnom_Penh', label:'Asia/Phnom_Penh'+'(UTC +07:00)' }]});

    const qr_code_img =
      `http://localhost/workzone/backend/uploads/qr_codes/` +
      formData.qr_code_img;
    let emp_id;
    let emp_id1;
    let dob;
    let code;
    let emp_id_label;
    let emp_id_label_2;
    let file_link;
    let file_link_profile;
    let img;
    let checkin_radio;
    let dob_dependant;
    let groupOp;
    groupOp = groups
      ? groups.map((cell, i) => {
          return { value: cell.id, label: cell.title };
          // return( value: cell.TimeZone, label: cell.TimeZone+'(UTC '+cell.UTC_offset+')' }
        })
      : "";
    if (this.state.user_id !== "0") {
      //  file_link = `https://alpha.workzoneplus.com/backend/uploads/banners/`+formData.image;
      //  file_link = `https://beta.workzoneplus.com/backend/uploads/banners/`+formData.image;
      // file_link = `http://localhost/workzone/workzone/backend/uploads/qr_codes/`+formData.qr_code_img;
      file_link =
        `http://beta.workzoneplus.com/backend/uploads/qr_codes/` +
        formData.qr_code_img;
      file_link_profile =
        `http://beta.workzoneplus.com/backend/uploads/profile_img/` +
        formData.profile_image;
      img = <img src={file_link} style={{ width: "70px", height: "70px" }} />;
    } else {
      file_link = "";
      img = "";
    }

    if (this.state.user_id != "0") {
      dob = dateFormat(formData.date_of_birth, "dd-mm-yyyy");
      dob_dependant = dateFormat(
        formData_dependant.dependant_date_of_birth,
        "dd-mm-yyyy"
      );

      emp_id1 = formData.employee_id;
      emp_id_label = "";
      emp_id_label_2 = (
        <Col lg={6}>
          <AvGroup>
            <Label className="label" for="example">
              Employee ID{" "}
              <span style={{ color: "red", fontSize: "15px" }}> *</span>
            </Label>
            <AvInput
              required
              name="employee_id"
              id="example"
              disabled
              value={emp_id1}
            />
            <AvFeedback>Enter Employee ID!</AvFeedback>
          </AvGroup>
        </Col>
      );
    } else {
      dob = dateFormat(this.state.date_of_birth, "dd-mm-yyyy");
      dob_dependant = dateFormat(
        this.state.dependant_date_of_birth,
        "dd-mm-yyyy"
      );
      if (hradmin.hr_code != "" || hradmin.org_code != "") {
        code = hradmin.hr_code + "-" + hradmin.org_code + "-";
        emp_id1 = "";
      } else {
        code = "-";
        emp_id1 = "";
      }
      emp_id_label = (
        <Col lg={3}>
          <AvGroup>
            <Label className="label" for="example">
              Employee ID
            </Label>
            {/* <Label className="code" for="example">{hradmin.hr_code+'-'+hradmin.org_code+'-'}</Label>  */}
            <AvInput
              className="code"
              name="code"
              className="emp_id"
              id="example"
              disabled
              value={code}
            />
          </AvGroup>
        </Col>
      );

      emp_id_label_2 = (
        <Col lg={3}>
          <AvGroup>
            <Label className="label" for="example">
              Employee ID{" "}
              <span style={{ color: "red", fontSize: "15px" }}> *</span>
            </Label>
            <AvInput
              name="employee_id"
              className="emp_id"
              id="example"
              value={emp_id1}
              required
            />
            <AvFeedback>Enter Employee ID!</AvFeedback>
          </AvGroup>
        </Col>
      );
      // dob = this.state.date_of_birth;
    }

    return (
      <Container fluid>
        <Header>
          <div id="google_translate_element_empval"></div>
          <br />
          <HeaderTitle>
            {this.state.user_id !== "0" ? "Edit" : "Add"}
          </HeaderTitle>
          <Breadcrumb>
            <BreadcrumbItem>
              <Link to="/dashboard">Dashboard</Link>
            </BreadcrumbItem>
            <BreadcrumbItem>
              <Link to="/employee/listing">Employees List</Link>
            </BreadcrumbItem>
            <BreadcrumbItem active>
              {this.state.user_id !== "0" ? "Edit" : "Add"}
            </BreadcrumbItem>
          </Breadcrumb>
        </Header>
        <Card>
          <CardBody>
            <AvForm id="pform" onValidSubmit={this.handleValidSubmit}>
              {/* With AvGroup AvInput and AvFeedback to build your own */}
              <Row>
                {emp_id_label}
                {emp_id_label_2}
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      First Name{" "}
                      <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    </Label>
                    <AvInput
                      name="first_name"
                      id="example"
                      required
                      value={formData ? formData.first_name : ""}
                    />
                    <AvFeedback>Enter First Name!</AvFeedback>
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">Middle Name</Label>
                    <AvInput
                      name="middle_name"
                      id="example"
                      value={formData ? formData.middle_name : ""}
                    />
                    {/* <AvFeedback>Enter Middle Name!</AvFeedback> */}
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      Last Name{" "}
                      <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    </Label>
                    <AvInput
                      name="last_name"
                      id="example"
                      required
                      value={formData ? formData.last_name : ""}
                    />
                    <AvFeedback>Enter Last Name!</AvFeedback>
                  </AvGroup>
                </Col>
              </Row>
              <Row>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      Email{" "}
                      <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    </Label>
                    <AvInput
                      name="email"
                      type="email"
                      id="example"
                      readonly={this.state.user_id != "0" ? "readonly" : false}
                      required
                      value={formData ? formData.email : ""}
                    />
                    <AvFeedback>Enter Email</AvFeedback>
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      Password{" "}
                      <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    </Label>
                    <AvInput
                      name="password"
                      id="example"
                      required
                      value={formData ? formData.password : ""}
                    />
                    <AvFeedback>Enter Password</AvFeedback>
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">Mobile No</Label>
                    <AvInput
                      name="mobile_no"
                      id="example"
                      type="number"
                      value={formData ? formData.mobile_no : ""}
                    />
                    {/* <AvFeedback>Enter a Valid Mobile No</AvFeedback> */}
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      Position{" "}
                      <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    </Label>
                    <AvInput
                      name="position"
                      id="example"
                      required
                      value={formData ? formData.designation : ""}
                    />
                    <AvFeedback>Enter Position</AvFeedback>
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      Department{" "}
                      <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    </Label>
                    <AvInput
                      name="department"
                      id="example"
                      required
                      value={formData ? formData.department : ""}
                    />
                    <AvFeedback>Enter Department</AvFeedback>
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  {/* <AvGroup> */}
                  <label>Select Gender</label>
                  <Select
                    value={gender}
                    name="gender"
                    onChange={this.gender}
                    options={genderOp}
                    isClearable
                    placeholder="Start Gender"
                  />
                  {/* </AvGroup> */}
                </Col>
                {/* <Col lg={6}>
                  <label>Select Organization <span style={{ color: "red", fontSize: "15px" }}> *</span></label>
                  <AvGroup>
                    <Select
                      value={organization_id}
                      name="organization_id"
                      onChange={this.organization_id}
                      options={orgOp}
                      isClearable
                      placeholder="Start Organization"
                    />
                  </AvGroup>
                </Col> */}
                <Col lg={6}>
                  {/* <AvGroup> */}
                  <Label for="example">
                    <label>
                      Select Organization{" "}
                      <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    </label>
                  </Label>

                  <AvField
                    type="select"
                    id="organization_id"
                    onChange={this.changeOrganization}
                    value={
                      formData
                        ? formData.organization_id
                        : this.state.organization_id
                    }
                    name="organization_id"
                    // className="mb-3"
                    validate={{
                      required: {
                        value: true,
                        errorMessage: "Select Organization",
                      },
                          }}
                  >
                    <option disabled={true} value="">
                      Select Organization
                    </option>
                    {org
                      ? org.map((cell, i) => {
                          return <option value={cell.id}>{cell.title}</option>;
                        })
                      : ""}
                    {/* <AvFeedback>Enter Leave</AvFeedback> */}
                  </AvField>

                  {/* </AvGroup> */}
                </Col>
                <Col lg={6}>
                  {/* <AvGroup> */}
                  <Label for="example">Date Of Birth (DD/MM/YYYY)</Label> <br />
                  {this.state.user_id !== "0" ? (
                    <DatePicker
                      name="date_of_birth"
                      selected={this.state.date_of_birth}
                      onChange={this.handleChange}
                      showYearDropdown
                      // disabled
                      yearDropdownItemNumber={15}
                      scrollableYearDropdown
                      className="re_date"
                      dateFormat="dd-MM-yyyy"
                      // value= { this.state.date_of_birth || formData.date_of_birth}
                      value={this.state.date_of_birth || dob}
                    />
                  ) : (
                    <DatePicker
                      name="date_of_birth"
                      selected={this.state.date_of_birth}
                      onChange={this.handleChange}
                      dateFormat="dd-MM-yyyy"
                      showYearDropdown
                      yearDropdownItemNumber={15}
                      scrollableYearDropdown
                      className="re_date"
                      //  value= { this.state.date_of_birth }
                      value={dob}
                    />
                  )}
                </Col>
                <Col lg={6}>
                  <label>Select Timezone</label>
                  <Select
                    value={timezone}
                    name="timezone"
                    onChange={this.timezone}
                    options={timezoneOp}
                    isClearable
                    placeholder="Select Timezone"
                  />
                </Col>
                <Col lg={6}>
                  <label>Select Status</label>
                  <Select
                    //  defaultValue={this.state.status}
                    name="status"
                    value={status}
                    onChange={this.status}
                    options={statusOp}
                    isClearable
                    placeholder="Select Status"
                  />
                </Col>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      Location Lat{" "}
                      <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    </Label>
                    <AvInput
                      name="location_lat"
                      id="example"
                      value={formData ? formData.location_lat : "0.0"}
                      required
                      type="number"
                    />
                    <AvFeedback>Enter Location Lat</AvFeedback>
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      Location Long{" "}
                      <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    </Label>
                    <AvInput
                      name="location_long"
                      id="example"
                      value={formData ? formData.location_long : "0.0"}
                      required
                      type="number"
                    />
                    <AvFeedback>Enter Location Long</AvFeedback>
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  {/* restrictCheckOutOp */}

                  <label>Restrict CheckIn Radius</label>
                  <AvGroup>
                    <Select
                      value={check_in_radius}
                      name="restrict_checkin_radius"
                      onChange={this.check_in_radius}
                      options={restrictCheckinOp}
                      isClearable
                      // placeholder='Select'
                    />
                  </AvGroup>
                </Col>
                <br />
                <br />
                <Col lg={6}>
                  <label>Restrict CheckOut Radius</label>
                  <Select
                    value={check_out_radius}
                    name="restrict_checkout_radius"
                    onChange={this.check_out_radius}
                    options={restrictCheckOutOp}
                    isClearable
                    // placeholder='Select'
                  />
                </Col>
                <br /> <br />
                <Col lg={6}>
                  <label>Select Nationality</label>
                  <Select
                    value={nationality}
                    name="nationality"
                    onChange={this.nationality}
                    options={natinalityOp}
                    isClearable
                    placeholder="Select Nationality"
                  />
                </Col>
                <Col lg={6}>
                  {/* <AvGroup> */}
                    <label>Select Resident</label>
                    <Select
                      value={resident}
                      name="is_resident"
                      onChange={this.resident}
                      options={residentOp}
                      isClearable
                      placeholder="Select Resident"
                    />
                  {/* </AvGroup> */}
                </Col>
                {/* <Col lg={6}>
                <AvGroup>
                <Label for="example">Select Employee Group</Label>
                  <Select
                   //label="Complaint Against"
                   value={employee_group}
                  name="employee_group"
                  placeholder='Select Employee Group'
                  options={groupOp}
                  onChange={this.handleGroupChange}
                  isClearable
                  
                />
               
                </AvGroup>
                </Col> */}
              
                <Col lg={6} >
                <label>Select Shift</label><span style={{ color: "red", fontSize: "15px" }}> *</span>
                  <AvField
                    type="select"
                    name="employee_shift"
                   // label="Select Shift"
                    required
                    //onChange={this.ochange}
                    value={formData ? formData.employee_shift :"0"}
                    validate={{
                      required: {
                        value: true,
                        errorMessage: "Select Shift",
                      },
                          }}
                  >
                    <option  value="0">Select Shift</option>
                    {shiftData
                      ? shiftData.map((cell) => {
                          return <option value={cell.id}>{cell.shift_name} ({cell.shift_code})</option>;
                        })
                      : ""}
                  </AvField>

                  

                 
                </Col>
                <Col lg={6}>
                  {/* <AvGroup> */}
                  <Label for="example">Employee Notes </Label>
                  <AvInput
                    name="employeeNotes"
                    id="example"
                    type="textarea"
                    value={formData ? formData.employeeNotes : ""}
                  />
                  {/* <AvFeedback>Enter Employee Notes</AvFeedback>
                  </AvGroup> */}
                </Col>
                <Col lg={6}>
                  {this.state.user_id != "0" ? (
                    <Label for="example">QR Code</Label>
                  ) : (
                    ""
                  )}
                  <br />
                  <br />
                  {img}
                  {"  "}
                  {this.state.user_id != "0" ? (
                    <a
                      target="_blank"
                      href={
                        "http://beta.workzoneplus.com/backend/uploads/qr_codes/" +
                        formData.qr_code_img
                      }
                    >
                      View QR code
                    </a>
                  ) : (
                    ""
                  )}
                </Col>
              </Row>
              <br />
              <br />

              <Row>
                <Col lg={6}>
                  <label>Profile Picture</label>
                  <FormGroup style={{ marginLeft: "19px" }} className="mb-2">
                    <Label>
                      <Input
                        type="radio"
                        name="photo_type"
                        value="up"
                        checked={this.state.up}
                        onChange={this.uploadphoto}
                      />
                      Upload Profile Image
                    </Label>
                  </FormGroup>
                  <FormGroup style={{ marginLeft: "19px" }} className="mb-2">
                    <Label>
                      <Input
                        type="radio"
                        name="photo_type"
                        value="tp"
                        checked={this.state.tp}
                        onChange={this.takephoto}
                      />
                      Take Profile Image
                    </Label>
                  </FormGroup>
                </Col>

                {/* {this.state.uploadedimage==true? formData.cv_link_url*/}

                {formData.profile_image ? (
                  <Col lg={6}>
                    {" "}
                    <img
                      src={file_link_profile}
                      id="preimg"
                      style={{ width: "150px", height: "150px" }}
                    />
                  </Col>
                ) : (
                  ""
                )}

                {/* <Col lg={6}>   {profileimg} </Col> */}
                {/* :''} */}
                {this.state.uploadphoto == true ? (
                  <Col lg={12}>
                    <AvGroup>
                      <Label for="example">
                        Upload
                        <span style={{ color: "red", fontSize: "15px" }}>
                          {" "}
                          *
                        </span>
                      </Label>{" "}
                      <br />
                      <Input
                        type="file"
                        name="image"
                        id="file"
                        accept="image/*"
                        //onChange={(e)=>this._handleImageChange(e)}

                        onChange={this.onSelectFile}
                      />
                      {/* 
<input type="file" accept="image/*" onChange={this.onSelectFile} /> */}
                      <br />
                      {srcrop && (
                        <ReactCrop
                          src={srcrop}
                          crop={crop}
                          ruleOfThirds
                          onImageLoaded={this.onImageLoaded}
                          onComplete={this.onCropComplete}
                          onChange={this.onCropChange}
                        />
                      )}
                      {/* {croppedImageUrl
        //  && (

          // <img alt="Crop" style={{ maxWidth: "100%" }} src={croppedImageUrl} />
       
      //  )
       
       } */}
                      <br />
                      {/* {$imagePreview}       */}
                    </AvGroup>
                    <small>('png','jpg','jpeg','JPG','pdf','docs')</small>
                    {/* {c_file_title} {c_file}<br/><br/> */}
                  </Col>
                ) : (
                  ""
                )}

                {this.state.takephoto == true ? (
                  <Col lg={12}>
                    {/* <App1 /> */}
                    <App />
                    {/* {srcrop && (
          <ReactCrop
            src={srcrop}
            crop={crop}
            ruleOfThirds
            onImageLoaded={this.onImageLoaded}
            onComplete={this.onCropComplete}
            onChange={this.onCropChange}
          />
        )}
        {croppedImageUrl && (
          <img alt="Crop" style={{ maxWidth: "100%" }} src={croppedImageUrl} />
        )}













{ this.state.screenshot &&   this.state.enable_image  ? 
				 
				 <img src={this.state.screenshot} style={{height:'100px',marginLeft:'100px'}}  />
         :''}










{ this.state.enable ?  

<Webcam audio ={false}  height={100} width={100}
ref={this.setRef}/> 


:''}

{ this.state.enable ?  
 <Button  onClick={() =>this.view()}  style={{marginLeft:'41px',marginTop:'-86px'}}   >{TF("{0}",T("OK"))}</Button>
 
 :''}
{ this.state.enabletry ?
<Button  onClick={() =>this.start_camara()}  style={{marginLeft:'14px',marginTop:'-86px'}}   >{T("Retry")}</Button>

:''} */}
                  </Col>
                ) : (
                  ""
                )}
                {/* {c_file_title} {c_file}<br/><br/> */}
              </Row>

              {this.state.user_id != "0" ? (
                <Button
                  color="primary"
                  className="addd_dep"
                  type="button"
                  onClick={() => this.toggle(this.state.user_id)}
                >
                  Add +
                </Button>
              ) : (
                ""
              )}
              <Modal
                isOpen={this.state[this.state.user_id]}
                toggle={() => this.toggle(this.state.user_id)}
              >
                <ModalHeader toggle={() => this.toggle(this.state.user_id)}>
                  Add Dependant
                </ModalHeader>
                <ModalBody className="text-center m-9">
                  <CardBody>
                    <AvForm id="dform">
                      <Row>
                        <Col lg={6}>
                          <AvGroup>
                            <Label for="example">Dependant Name* </Label>
                            <AvInput
                              name="dependant_name"
                              required
                              id="example"
                              value=""
                            />
                            <AvFeedback>Enter Dependant Name</AvFeedback>
                          </AvGroup>
                        </Col>
                        <Col lg={6}>
                          <label>Select Relation*</label>
                          <AvGroup>
                            <Select
                              value={relation}
                              name="relation"
                              onChange={this.relation}
                              options={deprOp}
                              required
                              isClearable
                              placeholder="Select Relation"
                            />
                          </AvGroup>
                        </Col>
                      </Row>

                      <Row>
                        <Col lg={6}>
                          <AvGroup>
                            <Label for="example">
                              Date Of Birth (DD/MM/YYYY)*
                            </Label>{" "}
                            <br />
                            {this.state.user_id != "0" ? (
                              <DatePicker
                                name="dependant_date_of_birth"
                                selected={this.state.dependant_date_of_birth}
                                onChange={this.handleDateChange}
                                // dateFormat="dd-mm-yyyy"
                                // className="re_date"
                                showYearDropdown
                                // disabled
                                yearDropdownItemNumber={15}
                                scrollableYearDropdown
                                className="re_date_dep"
                                dateFormat="dd-MM-yyyy"
                                // style={{width: '352px',height:'32px'}}
                                required
                                value={this.state.dependant_date_of_birth}
                              />
                            ) : (
                              <DatePicker
                                name="dependant_date_of_birth"
                                selected={this.state.dependant_date_of_birth}
                                class="re_date"
                                // className="re_date"
                                onChange={this.handleDateChange}
                                showYearDropdown
                                required
                                // disabled
                                yearDropdownItemNumber={15}
                                scrollableYearDropdown
                                className="re_date_dep"
                                dateFormat="dd-MM-yyyy"
                                value={this.state.dependant_date_of_birth}
                              />
                            )}
                          </AvGroup>
                        </Col>
                        <Col lg={6}>
                          <AvGroup>
                            <label>Select Relation*</label>
                            <Select
                              value={dependant_status}
                              name="dependant_status"
                              onChange={this.dependant_status}
                              options={depStatusOp}
                              required
                              isClearable
                              placeholder="Select Status"
                            />
                          </AvGroup>
                        </Col>
                        <Col lg={6}>
                          <AvGroup>
                            <Label for="example">Dependent Notes </Label>
                            <AvInput
                              name="dependentNotes"
                              id="example"
                              type="textarea"
                            />
                            <AvFeedback>Enter Dependent Notes</AvFeedback>
                          </AvGroup>
                        </Col>
                      </Row>
                    </AvForm>
                  </CardBody>
                </ModalBody>
                <br />
                <ModalFooter>
                  <Button
                    color="secondary"
                    onClick={() => this.toggle(this.state.user_id)}
                  >
                    Close
                  </Button>{" "}
                  <Button
                    // color={color.value}
                    onClick={() => this.handleValidSubmitDepandant()}
                  >
                    Save changes
                  </Button>
                </ModalFooter>
              </Modal>

              {/* // edit model */}
              <Modal
                isOpen={this.state[this.state.id]}
                toggle={() => this.toggleEdit(this.state.id)}
              >
                <ModalHeader toggle={() => this.toggleEdit(this.state.id)}>
                  Edit Dependant
                </ModalHeader>
                <ModalBody className="text-center m-9">
                  <CardBody>
                    <AvForm id="edform">
                      <Row>
                        <Col lg={6}>
                          <AvGroup>
                            <Label for="example">Dependant Name* </Label>
                            <AvInput
                              name="dependant_name"
                              id="example"
                              value={
                                formData_dependant_e
                                  ? formData_dependant_e.dependant_name
                                  : "0.0"
                              }
                            />
                            <AvFeedback>Enter Dependant Name</AvFeedback>
                          </AvGroup>
                        </Col>
                        <Col lg={6}>
                          <AvGroup>
                            <label>Select Relation*</label>
                            <Select
                              value={relation}
                              name="relation"
                              onChange={this.relation}
                              options={deprOp}
                              isClearable
                              placeholder="Select Relation"
                            />
                          </AvGroup>
                        </Col>
                      </Row>
                      {/* <Row>
                           
                          </Row> */}
                      <Row>
                        <Col lg={6}>
                          <AvGroup>
                            <Label for="example">
                              Date Of Birth (DD/MM/YYYY)*
                            </Label>{" "}
                            <br />
                            {this.state.user_id != "0" ? (
                              <DatePicker
                                name="dependant_date_of_birth"
                                selected={this.state.dependant_date_of_birth}
                                onChange={this.handleDateChange}
                                dateFormat="dd-mm-yyyy"
                                showYearDropdown
                                // disabled
                                yearDropdownItemNumber={15}
                                scrollableYearDropdown
                                className="re_date_dep"
                                dateFormat="dd-MM-yyyy"
                                // style={{width: '352px',height:'32px'}}
                                value={
                                  this.state.dependant_date_of_birth ||
                                  formData_dependant_e.dependant_date_of_birth
                                }
                              />
                            ) : (
                              <DatePicker
                                name="dependant_date_of_birth"
                                selected={this.state.dependant_date_of_birth}
                                class="re_date"
                                className="re_date_dep"
                                onChange={this.handleDateChange}
                                showYearDropdown
                                // disabled
                                yearDropdownItemNumber={15}
                                scrollableYearDropdown
                                className="re_date"
                                dateFormat="dd-MM-yyyy"
                                value={this.state.dependant_date_of_birth}
                              />
                            )}
                          </AvGroup>
                        </Col>
                        <Col lg={6}>
                          <AvGroup>
                            <label>Select Relation*</label>
                            <Select
                              value={dependant_status}
                              name="dependant_status"
                              onChange={this.dependant_status}
                              options={depStatusOp}
                              isClearable
                              placeholder="Select Status"
                            />
                          </AvGroup>
                        </Col>
                      </Row>
                      <Col lg={6}>
                        <AvGroup>
                          <Label for="example">Dependent Notes </Label>
                          <AvInput
                            name="dependentNotes"
                            id="example"
                            type="textarea"
                            value={
                              formData_dependant_e
                                ? formData_dependant_e.dependentNotes
                                : ""
                            }
                          />
                          <AvFeedback>Enter Dependent Notes</AvFeedback>
                        </AvGroup>
                      </Col>
                    </AvForm>
                  </CardBody>
                </ModalBody>

                <ModalFooter>
                  <Button
                    color="secondary"
                    onClick={() => this.toggleEdit(this.state.id)}
                  >
                    Close
                  </Button>{" "}
                  <Button
                    // color={color.value}
                    onClick={() => this.handleUpdateDepandant()}
                  >
                    Save changes
                  </Button>
                </ModalFooter>
              </Modal>
              {this.state.user_id != "0" ? (
                <ToolkitProvider
                  keyField="name"
                  data={this.state.formData_dependant}
                  columns={tableColumns}
                  // exportCSV
                >
                  {(props) => (
                    <BootstrapTable
                      {...props.baseProps}
                      bootstrap4
                      bordered={false}
                      pagination={paginationFactory({
                        // sizePerPage: 25,
                        sizePerPage: 10,
                        sizePerPageList: [5, 10, 25, 50],
                      })}
                    />
                  )}
                </ToolkitProvider>
              ) : (
                ""
              )}
              <br />
              <br />

              <FormGroup>
                <Link
                  to="/employee/listing"
                  style={{
                    margin: "0rem 1.50rem 1.50rem 0rem",
                    border: "#6f42c1 1px solid",
                    color: "#6f42c1",
                    padding: "0.10rem 0.90rem 0.30rem 0.90rem",
                    textDecoration: "none",
                    borderRadius: "0.2rem",
                  }}
                >
                  Cancel
                </Link>
                {this.state.user_id != "0" ? (
                  <Button disabled={submitted}>
                    {(submitted && "Your form is submitted!") ||
                      (!submitted && "Update")}
                  </Button>
                ) : (
                  <Button disabled={submitted}>
                    {(submitted && "Your form is submitted!") ||
                      (!submitted && "Add")}
                  </Button>
                )}
              </FormGroup>
            </AvForm>
          </CardBody>
        </Card>
      </Container>
    );
  }
}

export default Validation;
