import React,{ PureComponent } from "react";
import { Link } from "react-router-dom";
import * as myConstClass from '../../constant.js';
import $ from 'jquery'; 
import {
  Breadcrumb,
  BreadcrumbItem, Button,
  Card,
  CardBody,
  CardHeader,
  CardTitle,
  Container, Modal,
  ModalBody,
  ModalFooter,
  ModalHeader,
} from "reactstrap";

import Header from "../../components/Header";
import HeaderTitle from "../../components/HeaderTitle";

import BootstrapTable from "react-bootstrap-table-next";
import ToolkitProvider from "react-bootstrap-table2-toolkit";
import paginationFactory from "react-bootstrap-table2-paginator";
import { toastr } from "react-redux-toastr";
import * as Icon from "react-feather";

const tableColumns = [
  {
    dataField: "title",
    text: "Name",
    sort: true,
    headerStyle: { width:"40%" }
  },
  {
    dataField: "source",
    text: "Source",
    sort: true,
    headerStyle: { width:"15%" }
  },
  {
    dataField: "igroup",
    text: "Group",
    sort: true,
    headerStyle: { width:"15%" }
  },
  {
    dataField: "quantity",
    text: "Quantity",
    sort: true,
    headerStyle: { width:"15%" }
  },
  {
    dataField: "unit",
    text: "Unit",
    sort: true,
    headerStyle: { width:"10%" }
    
  },
  {
    dataField: "action",
    text: "Action",
    headerStyle: { width:"10%" }
  },
  
];

const MyExportCSV = props => {
  const handleClick = () => {
    props.onExport();
  };
  return (
    <div>
        <button className="btn btn-secondary mt-2" onClick={handleClick}>
        Export
      </button>
    </div>
    
  );
};

class Measures extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      user_id:0,
      formData:'',
      timeOut: 5000,
      showCloseButton: true,
      progressBar: true,
      position: "top-right"
    }
  }

  edit(e) { 
    this.props.history.push('/ingredients/add/'+e);
  }
  
  remove(e) { 
    const options = {
      timeOut: parseInt(this.state.timeOut),
      showCloseButton: this.state.showCloseButton,
      progressBar: this.state.progressBar,
      position: this.state.position
    };
    this.flag = 1;
    fetch(myConstClass.BASE_URL+`/ingredient/deleteIngredient`, {
    method: 'POST',
    body: e,
  }).then(toastr.success(
    'Success',
    "Ingredient Deleted Successfully..!",
    options
  ),

  fetch(myConstClass.BASE_URL+'/ingredient/getIngredients/')
  .then(response => response.json())
  .then(response =>{
    let i=1;  
  response.forEach(element => {
    let id=element.uid;
  element.action = <div><Icon.Edit3 style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.edit(id)} /><Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/></div>;
   // console.log(element);
   element.uid = i;
   i++;
  });
  this.setState({formData: response})
}).catch(err => console.log(err))
  )
  .catch();

  
  }

  componentDidMount(){
    document.querySelector('.react-bootstrap-table').style.minHeight  = "243px";
    fetch(myConstClass.BASE_URL+'/ingredient/getIngredients/')
  .then(response => response.json())
  .then(response =>{
    let i=1;  
  response.forEach(element => {
    let id=element.uid;
  element.action = <div><Icon.Edit3 style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.edit(id)} /><Icon.Trash2 style={{cursor:'Pointer'}}  onClick={() =>this.remove(id)}/></div>;
   // console.log(element);
   element.uid = i;
   i++;
  });
  this.setState({formData: response})
}).catch(err => console.log(err))
  }

  render() { 
    return(
  <Container fluid>
    <Header>
      <HeaderTitle>Ingredients</HeaderTitle>

      <Breadcrumb>
        <BreadcrumbItem>
          <Link to="/dashboard">Dashboard</Link>
        </BreadcrumbItem>
        {/* <BreadcrumbItem>
          <Link to="/dashboard">measures</Link>
        </BreadcrumbItem> */}
        <BreadcrumbItem active>Ingredients</BreadcrumbItem>
        <button class="mr-1 mb-1 btn btn-outline-secondary" onClick={() =>this.edit(this.state.user_id)} style={{color:'#ffffff',border: '1px solid #ffffff',float:'right !important',margin:'auto'}}><Icon.PlusCircle />&nbsp;&nbsp;ADD</button>
     
      </Breadcrumb>
      {/* <span >ADD</span> */}
      
    </Header>
    <Card>
      <ToolkitProvider
        keyField="name"
        data={this.state.formData}
        columns={tableColumns}
        exportCSV
      >
        {props => (
          <div>
            <CardHeader> 
              <div className="float-right pull-right">
              
                <MyExportCSV {...props.csvProps} />
              </div><br/>
              {/* <CardTitle tag="h5">Export CSV</CardTitle>
              <h6 className="card-subtitle text-muted">
                Exportable CSV by react-bootstrap-table2
              </h6> */}
            </CardHeader>
            <CardBody>
              <BootstrapTable
                {...props.baseProps}
                bootstrap4
                bordered={false}
                pagination={paginationFactory({ 
                  sizePerPage: 25,
                  sizePerPageList: [5, 10, 25, 50]
                })}
              />
            </CardBody>   
          </div>
        )}
      </ToolkitProvider>
    </Card>
    
    {/* <ExportCSVTable /> */}
  </Container>
    );
}
}

export default Measures;
