import React, { PureComponent } from "react";
import { Link } from "react-router-dom";
import * as myConstClass from "../../constant.js";
import DatePicker from "react-datepicker";
import swal from "sweetalert";
import "react-datepicker/dist/react-datepicker.css";
import "./datepicker.scss";
import dateFormat from "dateformat";
import ImageGallery from "react-image-gallery";
import "react-image-gallery/styles/css/image-gallery.css";
import { AudioPlayer } from "react-audio-play";
import {
  Breadcrumb,
  BreadcrumbItem,
  Row,
  Label,
  Card,
  CardBody,
  CardHeader,
  Container,
  ModalHeader,
  Modal,
  ModalBody,
  Button,
  ModalFooter,
} from "reactstrap";

import Header from "../../components/Header";
import HeaderTitle from "../../components/HeaderTitle";
import { CSVLink } from "react-csv";

import BootstrapTable from "react-bootstrap-table-next";
import ToolkitProvider, { Search } from "react-bootstrap-table2-toolkit";
import paginationFactory from "react-bootstrap-table2-paginator";
import { toastr } from "react-redux-toastr";
import * as Icon from "react-feather";
import "react-confirm-alert/src/react-confirm-alert.css"; // Import css
import {
  AvForm,
  AvField,
  AvGroup,
  AvInput,
} from "availity-reactstrap-validation";
const { SearchBar } = Search;
const tableColumns = [
  {
    dataField: "employee_id",
    text: "Employee",
    sort: true,
    headerStyle: { width: "10%" },
  },
  {
    dataField: "from_date",
    text: "From Date",
    sort: true,
    headerStyle: { width: "10%" },
  },
  {
    dataField: "to_date",
    text: "To Date",
    sort: true,
    headerStyle: { width: "10%" },
  },
  {
    dataField: "leave_type_id",
    text: "Leave Type",
    sort: true,
    headerStyle: { width: "10%" },
  },
  {
    dataField: "total_days",
    text: "Total Days",
    sort: true,
    headerStyle: { width: "10%" },
  },
  {
    dataField: "reason",
    text: "Reason",
    sort: true,
    headerStyle: { width: "10%" },
  },
  {
    dataField: "status",
    text: "Status",
    sort: true,
    headerStyle: { width: "10%" },
  },
  {
    dataField: "action",
    text: "Action",
    headerStyle: { width: "10%" },
    csvExport: false,
  },
];
const tableColumnsHeader = [
  {
    key: "employee_id",
    label: "Employee",
  
  },
  {
    key: "from_date",
    label: "From Date",
   
  },
  {
    key: "to_date",
    label: "To Date",
    
  },
  {
    key: "leave_type_id",
    label: "Leave Type",
  
  },
  {
    key: "total_days",
    label: "Total Days",
   
  },
  {
    key: "reason",
    label: "Reason",
    
  },
  {
    key: "status",
    label: "Status",
    
  },
  
];

class Leaves extends PureComponent {
  constructor(props) {
    super(props);
    this.routeChange = this.routeChange.bind(this);
    // this.googleTranslateElementInit =
    //   this.googleTranslateElementInit.bind(this);
    this.search = this.search.bind(this);
    this.state = {
      user_id: 0,
      from_date: Date.now(),
      to_date: Date.now(),
      formData: [],
      emp: "",
      posts: "",
      timeOut: 5000,
      showCloseButton: true,
      progressBar: true,
      position: "top-right",
      images: [],
      showIndex: false,
      showBullets: true,
      infinite: true,
      showThumbnails: true,
      showFullscreenButton: true,
      showGalleryFullscreenButton: true,
      showPlayButton: true,
      showGalleryPlayButton: true,
      showNav: true,
      isRTL: false,
      slideDuration: 450,
      slideInterval: 2000,
      slideOnThumbnailOver: false,
      thumbnailPosition: "bottom",
      showVideo: {},
    };
    this.flag = 0;
    this.cid = 0;
    this.oid = 0;
    this.change = this.change.bind(this);
    this.ochange = this.ochange.bind(this);

    this.csvColumns = [
      {
        displayName: "Employee",
        id: "employee_id",
      },
      { displayName: "From_Date", id: "from_date" },
      { displayName: "To Date", id: "to_date" },
      { displayName: "Leave_Type", id: "leave_type_id" },
      { displayName: "Total Days", id: "total_days" },
      { displayName: "Reason", id: "reason" },
      { displayName: "Status", id: "status" },
    ];

    //   submitted: false,
  }

  edit(e) {
    this.props.history.push("/leaves/add/" + e);
  }

  remove(e) {
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    swal({
      title: "Are you sure?",
      text: "Are you sure that you want to delete this record?",
      icon: "warning",
      // buttons: true,
      buttons: {
        confirm: {
          text: "OK",
          value: true,
          visible: true,
          className: "",
          closeModal: true,
        },
        cancel: {
          text: "Cancel",
          value: false,
          visible: true,
          className: "Custom_Cancel",
          closeModal: true,
        },
      },
      dangerMode: true,
    }).then((result) => {
      if (result) {
        const options = {
          timeOut: parseInt(this.state.timeOut),
          showCloseButton: this.state.showCloseButton,
          progressBar: this.state.progressBar,
          position: this.state.position,
        };
        this.flag = 1;
        fetch(myConstClass.BASE_URL + `/attendance/deletLeaves/` + admin_id, {
          method: "POST",
          body: e,
        })
          .then(
            toastr.success(
              "Success",
              "Leaves Deleted Successfully..!",
              options
            ),

            fetch(
              myConstClass.BASE_URL +
                "attendance/getLeaves/" +
                admin_id +
                "/" +
                this.cid +
                "/" +
                fdate +
                "/" +
                tdate
            )
              .then((response) => response.json())
              .then((response) => {
                let i = 1;
                response.forEach((element) => {
                  let id = element.leave_id;
                  element.action = (
                    <div>
                      <Icon.PlayCircle
                        style={
                          element.reason_audio
                            ? { margin: "0px 15px 0px 0px", cursor: "Pointer" }
                            : { display: "none" }
                        }
                        onClick={() =>
                          this.handleOk(
                            element.leaveEmployeeId,
                            element.reason_audio
                          )
                        }
                      />
                      <Icon.Edit3
                        style={{
                          margin: "0px 15px 0px 0px",
                          cursor: "Pointer",
                        }}
                        onClick={() => this.edit(id)}
                      />
                      <Icon.Trash2
                        style={{ cursor: "Pointer" }}
                        onClick={() => this.remove(id)}
                      />
                    </div>
                  );
                  element.leave_id = i;
                  i++;
                });
                this.setState({ formData: response });
              })
              .catch((err) => console.log(err))
          )
          .catch();
      }
    });
  }

  // remove(e) {
  //   var admin_id = localStorage.getItem('uname');
  //   const options = {
  //       timeOut: parseInt(this.state.timeOut),
  //       showCloseButton: this.state.showCloseButton,
  //       progressBar: this.state.progressBar,
  //       position: this.state.position
  //     };
  //     this.flag = 1;
  //   confirmAlert({

  //     title: '',
  //     message: 'Are you sure ?',
  //     buttons: [
  //       {
  //         label: 'Yes',
  //         onClick: () =>fetch(myConstClass.BASE_URL+`attendance/deletLeaves/`, {
  //           method: 'POST',
  //           body: e,
  //         }).then(toastr.success( 'Success', "Leave Deleted Successfully..!", options),
  //         fetch(myConstClass.BASE_URL+'attendance/getLeaves/'+admin_id)
  //         .then(response =>response.json()
  //       ).then(response =>{
  //           let i=1;
  //           response.forEach(element => {
  //               let id=element.leave_id;
  //               element.action = <div><Icon.Edit3 style={{margin:'0px 15px 0px 0px',cursor:'Pointer'}} onClick={() =>this.edit(id)} /><Icon.Trash2 style={{cursor:'Pointer'}} onClick={() =>this.remove(id)}/></div>;
  //               element.leave_id = i;
  //               i++;
  //               });
  //         this.setState({posts: response})
  //       })
  //       .catch(err => console.log(err))
  //         )
  //         .catch()
  //       },
  //       {
  //         label: 'No',
  //         onClick: () => <Redirect to='/leaves/listing'  />
  //       }
  //     ]
  //   });
  // }

  ochange(event) {
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    this.oid = event.target.value;
    fetch(
      myConstClass.BASE_URL +
        "attendance/getLeaves/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        event.target.value
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.leave_id;
          element.action = (
            <div>
              <Icon.PlayCircle
                style={
                  element.reason_audio
                    ? { margin: "0px 15px 0px 0px", cursor: "Pointer" }
                    : { display: "none" }
                }
                onClick={() =>
                  this.handleOk(element.leaveEmployeeId, element.reason_audio)
                }
              />
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          element.leave_id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));

    fetch(
      myConstClass.BASE_URL +
        "user/get_all_Employees/" +
        admin_id +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        this.setState({ emp: response });
      })
      .catch((err) => console.log(err));
  }

  change(event) {
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    this.cid = event.target.value;
    fetch(
      myConstClass.BASE_URL +
        "attendance/getLeaves/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.leave_id;
          element.action = (
            <div>
              <Icon.PlayCircle
                style={
                  element.reason_audio
                    ? { margin: "0px 15px 0px 0px", cursor: "Pointer" }
                    : { display: "none" }
                }
                onClick={() =>
                  this.handleOk(element.leaveEmployeeId, element.reason_audio)
                }
              />
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          element.leave_id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
  }

  handleFromDateChange = (from_date) => {
    this.setState({ from_date });
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");

    fetch(
      myConstClass.BASE_URL +
        "attendance/getLeaves/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.leave_id;
          element.action = (
            <div>
              <Icon.PlayCircle
                style={
                  element.reason_audio
                    ? { margin: "0px 15px 0px 0px", cursor: "Pointer" }
                    : { display: "none" }
                }
                onClick={() =>
                  this.handleOk(element.leaveEmployeeId, element.reason_audio)
                }
              />
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          element.leave_id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
    var from = { from_date };
  };

  handleToDateChange = (to_date) => {
    this.setState({ to_date });
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(to_date, "yyyy-mm-dd");
    fetch(
      myConstClass.BASE_URL +
        "attendance/getLeaves/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.leave_id;
          element.action = (
            <div>
              <Icon.PlayCircle
                style={
                  element.reason_audio
                    ? { margin: "0px 15px 0px 0px", cursor: "Pointer" }
                    : { display: "none" }
                }
                onClick={() =>
                  this.handleOk(element.leaveEmployeeId, element.reason_audio)
                }
              />
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          element.leave_id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
    var to = { to_date };
  };

  routeChange() {
    this.props.history.push("/");
  }

  handleOk = (e, audioName) => {
    // var admin_id = localStorage.getItem("uname");
    // fetch(
    //   myConstClass.BASE_URL +
    //     "user/getLeaveAudioResult/" +
    //     e +
    //     "/" +
    //     admin_id +
    //     "/" +
    //     audioName
    // )
    //   .then((response) => response.json())
    //   .then((response) => {
    //     response.forEach((element) => {
    //       element.renderItem = this._renderVideo.bind(this);
    //     });

    //     this.setState({ images: response });
    //   })
    //   .catch((err) => console.log(err));
    //$().add('https://beta.workzoneplus.com/backend/uploads/leaves/'+e+'/'+audioName)
    this.setState({
      audioSrc:
        "https://beta.workzoneplus.com/backend/uploads/leaves/" +
        e +
        "/" +
        audioName,
    });
    this.setState({ visiblepoints2: true });
  };
  handleCancelVidio = (e) => {
    this.setState({ visiblepoints2: false });
  };
  search(event) {
    var admin_id = localStorage.getItem("uname");
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    this.sid = event.target.value;
    if (this.sid == null || this.sid == "") {
      this.sid = 0;
    } else {
      this.sid = event.target.value;
    }
    fetch(
      myConstClass.BASE_URL +
        "attendance/getLeavesOnSearch/" +
        admin_id +
        "/" +
        this.sid +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.leave_id;
          element.action = (
            <div>
              <Icon.PlayCircle
                style={
                  element.reason_audio
                    ? { margin: "0px 15px 0px 0px", cursor: "Pointer" }
                    : { display: "none" }
                }
                onClick={() =>
                  this.handleOk(element.leaveEmployeeId, element.reason_audio)
                }
              />
              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          element.leave_id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));
  }
  componentDidMount() {
    // window.googleTranslateElementInit = this.googleTranslateElementInit;
    // const google = window.google;
    // const script = document.createElement("script");
    // script.src =
    //   "//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit";
    // script.async = true;
    // document.body.appendChild(script);

    document.querySelector(".react-bootstrap-table").style.minHeight = "243px";
    var admin_id = localStorage.getItem("uname");
    if (admin_id == null) {
      this.routeChange();
    }
    var fdate = dateFormat(this.state.from_date, "yyyy-mm-dd");
    var tdate = dateFormat(this.state.to_date, "yyyy-mm-dd");
    fetch(
      myConstClass.BASE_URL +
        "attendance/getLeaves/" +
        admin_id +
        "/" +
        this.cid +
        "/" +
        fdate +
        "/" +
        tdate +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        let i = 1;
        response.forEach((element) => {
          let id = element.leave_id;
          element.action = (
            <div>
              <Icon.PlayCircle
                style={
                  element.reason_audio
                    ? { margin: "0px 15px 0px 0px", cursor: "Pointer" }
                    : { display: "none" }
                }
                onClick={() =>
                  this.handleOk(element.leaveEmployeeId, element.reason_audio)
                }
              />

              <Icon.Edit3
                style={{ margin: "0px 15px 0px 0px", cursor: "Pointer" }}
                onClick={() => this.edit(id)}
              />
              <Icon.Trash2
                style={{ cursor: "Pointer" }}
                onClick={() => this.remove(id)}
              />
            </div>
          );
          element.leave_id = i;
          i++;
        });
        this.setState({ formData: response });
      })
      .catch((err) => console.log(err));

    fetch(
      myConstClass.BASE_URL +
        "user/get_all_Employees/" +
        admin_id +
        "/" +
        this.oid
    )
      .then((response) => response.json())
      .then((response) => {
        this.setState({ emp: response });
      })
      .catch((err) => console.log(err));

    fetch(
      myConstClass.BASE_URL + "organization/get_all_organizations/" + admin_id
    )
      .then((response) => response.json())
      .then((response) => {
        if (admin_id != "0") {
          response.forEach((element) => {
            this.setState({ organization_id: element.id });
          });
        }
        this.setState({ org: response });
      })
      .catch((err) => console.log(err));
  }

  _onImageClick(event) {
    console.debug(
      "clicked on image",
      event.target,
      "at index",
      this._imageGallery.getCurrentIndex()
    );
  }

  _onImageLoad(event) {
    console.debug("loaded image", event.target.src);
  }

  _onSlide(index) {
    this._resetVideo();
    console.debug("slid to index", index);
  }

  _onPause(index) {
    console.debug("paused on index", index);
  }

  _onScreenChange(fullScreenElement) {
    console.debug("isFullScreen?", !!fullScreenElement);
  }

  _onPlay(index) {
    console.debug("playing from index", index);
  }

  _handleInputChange(state, event) {
    this.setState({ [state]: event.target.value });
  }

  _handleCheckboxChange(state, event) {
    this.setState({ [state]: event.target.checked });
  }

  _handleThumbnailPositionChange(event) {
    this.setState({ thumbnailPosition: event.target.value });
  }

  _resetVideo() {
    this.setState({ showVideo: {} });

    if (this.state.showPlayButton) {
      this.setState({ showGalleryPlayButton: true });
    }

    if (this.state.showFullscreenButton) {
      this.setState({ showGalleryFullscreenButton: true });
    }
  }

  _toggleShowVideo(url) {
    this.state.showVideo[url] = !Boolean(this.state.showVideo[url]);
    this.setState({
      showVideo: this.state.showVideo,
    });

    if (this.state.showVideo[url]) {
      if (this.state.showPlayButton) {
        this.setState({ showGalleryPlayButton: false });
      }

      if (this.state.showFullscreenButton) {
        this.setState({ showGalleryFullscreenButton: false });
      }
    }
  }

  _renderVideo(item) {
    // alert(item.embedUrl);
    return (
      <div>
        {this.state.showVideo[item.embedUrl] ? (
          <div className="video-wrapper">
            <a
              className="close-video"
              onClick={this._toggleShowVideo.bind(this, item.embedUrl)}
            ></a>
            <iframe
              width="560"
              height="315"
              src={item.embedUrl}
              frameBorder="0"
              allowFullScreen
            ></iframe>
          </div>
        ) : (
          <a onClick={this._toggleShowVideo.bind(this, item.embedUrl)}>
            <div className="play-button"></div>
            <img className="image-gallery-image" src={item.original} />
            {item.description && (
              <span
                className="image-gallery-description"
                style={{ right: "0", left: "initial" }}
              >
                {item.description}
              </span>
            )}
          </a>
        )}
      </div>
    );
  }

  // googleTranslateElementInit() {
  //   // / eslint-disable no-new /
  //   const google = window.google;
  //   new google.translate.TranslateElement(
  //     { pageLanguage: "en" },
  //     "google_translate_element"
  //   );
  //   new window.google.translate.TranslateElement(
  //     {
  //       pageLanguage: "pt",
  //       layout: window.google.translate.TranslateElement.FloatPosition.TOP_LEFT,
  //     },
  //     "google_translate_element"
  //   );
  // }

  archievedLeave() {
    this.props.history.push("/leaves/listingdel");
  }

  render() {
    var admin_id = localStorage.getItem("uname");
    var is_archived = localStorage.getItem("is_archived");
    const { emp, images } = this.state;
    const { org } = this.state;

    const csvColumns = this.csvColumns;
    const csvData = this.state.formData;
    let fileName = "Employees_Leaves" + new Date().getTime() + ".csv";
    let tableData;
    const minDate = new Date();
    minDate.setMonth(minDate.getMonth() - 12);

    // var admin_id= localStorage.getItem('uname');
    return (
      <Container fluid>
        <Header>
          {/* <div id="google_translate_element"></div>
          <br /> */}
          <HeaderTitle>Leave List</HeaderTitle>

          <Breadcrumb>
            <BreadcrumbItem>
              <Link to="/dashboard">Dashboard</Link>
            </BreadcrumbItem>
            {/* <BreadcrumbItem>
              <Link to="/dashboard">measures</Link>
            </BreadcrumbItem> */}
            <BreadcrumbItem active>Leave List</BreadcrumbItem>
            {admin_id != "0" ? (
              <button
                class="mr-1 mb-1 btn btn-outline-secondary"
                onClick={() => this.edit(this.state.user_id)}
                style={{
                  color: "#ffffff",
                  border: "1px solid #ffffff",
                  float: "right !important",
                  margin: "auto",
                }}
              >
                <Icon.PlusCircle />
                &nbsp;&nbsp;ADD
              </button>
            ) : (
              ""
            )}
          </Breadcrumb>
        </Header>
        <Card>
          <AvForm id="sform">
            <Row className="f_class_leave">
              <div class="col-md-4"></div>
              <div class="col-md-4"></div>
            </Row>
          </AvForm>
          <br />
          <ToolkitProvider
            keyField="name"
            data={this.state.formData}
            columns={tableColumns}
            exportCSV
            search
          >
            {(props) => (
              <div>
                <CardHeader>
                  {/* <div className="float-right pull-right"> */}

                  {/* <div class="float-right pull-right" style={{ left: '398px',top: '-21px'}}>
                    <CsvDownloader
                    className="csv"
                    style={{float:'right',backgroundColor:"#4B0082"}}
                    filename={fileName}
                      columns={csvColumns}
                      datas={csvData}
                    text="Export" /></div> */}

                  {/* <MyExportCSV {...props.csvProps} />
                  </div><br/> */}
                  {/* <CardTitle tag="h5">Export CSV</CardTitle>
                  <h6 className="card-subtitle text-muted">
                    Exportable CSV by react-bootstrap-table2
                  </h6> */}
                </CardHeader>
                <CardBody>
                  <AvForm id="pform" onValidSubmit={this.handleValidSubmit}>
                    {/* With AvGroup AvInput and AvFeedback to build your own */}
                    <Row>
                      <div class="col-md-3">
                        <AvGroup>
                          <AvField
                            type="select"
                            name="organization_id"
                            label="Select Organization"
                            onChange={this.ochange}
                            value={this.state.organization_id}
                          >
                            <option value={0}>All Organization</option>
                            {org
                              ? org.map((cell, i) => {
                                  return (
                                    <option value={cell.id}>
                                      {cell.title}
                                    </option>
                                  );
                                })
                              : ""}
                          </AvField>
                        </AvGroup>
                      </div>
                      <div class="col-md-3">
                        <AvGroup>
                          {/* <AvInput name="employee_id" id="example" required value={formData ? formData.employee_id:''}/>
                  <AvFeedback>Enter Employee ID!</AvFeedback> */}
                          <AvField
                            type="select"
                            name="employee_id"
                            label="Select Employee"
                            onChange={this.change}
                            value={this.state.employee_id}
                          >
                            <option value="0">All Employee</option>
                            {emp
                              ? emp.map((cell, i) => {
                                  return (
                                    <option value={cell.id}>
                                      {cell.first_name} {cell.last_name}
                                    </option>
                                  );
                                })
                              : ""}
                          </AvField>
                        </AvGroup>
                      </div>
                      <div class="col-md-3">
                        {/* <AvGroup> */}
                        <Label for="example">From Date </Label> <br />
                        <DatePicker
                          name="from_date"
                          selected={this.state.from_date}
                          onChange={this.handleFromDateChange}
                          dateFormat="dd-MM-yyyy"
                          className="is-untouched is-pristine av-valid form-control"
                          minDate={minDate}
                          value={this.state.from_date}
                        />
                      </div>
                      <div class="col-md-3">
                        {/* <AvGroup> */}
                        <Label for="example">To Date </Label> <br />
                        <DatePicker
                          name="to_date"
                          selected={this.state.to_date}
                          onChange={this.handleToDateChange}
                          dateFormat="dd-MM-yyyy"
                          className="is-untouched is-pristine av-valid form-control"
                          minDate={minDate}
                          value={this.state.to_date}
                        />
                      </div>
                    </Row>
                    <br />
                    <Row>
                      <div class="col-md-4">
                        {/* <MyExportCSV {...props.csvProps} /> */}
                        <CSVLink
                          className="btn btn-secondary mt-2"
                          style={{ margin: "0rem 1.50rem 0rem 0rem" }}
                          data={this.state.formData}
                          headers={tableColumnsHeader}
                          filename="Leave List.csv"
                        >
                          Export
                        </CSVLink>
                        <button
                          className="btn btn-secondary mt-2"
                          style={
                            is_archived == "1"
                              ? { margin: "0rem 1.50rem 0rem 0rem" }
                              : { display: "none" }
                          }
                          onClick={() => this.archievedLeave()}
                        >
                          Archieved
                        </button>
                      </div>

                      <div class="col-md-4"></div>
                      {/* <div class="col-md-4"></div>
              <div class="col-md-4">
                <AvGroup>
                  <Label for="example" className="search_title">Search</Label>
                  <AvInput name="search" className="search" onChange={this.search} type="text" id="example"/>
                </AvGroup>
              </div> */}
                      <div class="col-md-4">
                        <Label for="example"></Label>
                        <SearchBar
                          {...props.searchProps}
                          placeholder="Search"
                        />
                      </div>
                    </Row>
                  </AvForm>
                  <br />
                  <BootstrapTable
                    {...props.baseProps}
                    bootstrap4
                    bordered={false}
                    pagination={paginationFactory({
                      // sizePerPage: 25,
                      sizePerPage: 10,
                      sizePerPageList: [5, 10, 25, 50],
                    })}
                  />
                </CardBody>
              </div>
            )}
          </ToolkitProvider>

          <Modal
            size="lg"
            style={{ maxWidth: "700px", width: "100%" }}
            isOpen={this.state.visiblepoints2}
          >
            <ModalHeader></ModalHeader>
            <ModalBody className="text-center m-9">
              <CardHeader>Audio Reason</CardHeader>
              <CardBody>
                {/* <audio src="https://appkh.wzone.biz/backend/t/IDFG/uploads/leaves/3/Reason_3audio_1709278879.mp3" autoplay></audio> */}

                <AudioPlayer
                  id="reason_audio"
                  loop
                  src={this.state.audioSrc}
                  // src="https://appkh.wzone.biz/backend/t/IDFG/uploads/leaves/3/Reason_3audio_1709278879.mp3"
                  volume={50}
                  volumePlacement="bottom"
                />

                {/* <ImageGallery
                  ref={(i) => (this._imageGallery = i)}
                  items={images}
                  lazyLoad={false}
                  onClick={this._onImageClick.bind(this)}
                  onImageLoad={this._onImageLoad}
                  onSlide={this._onSlide.bind(this)}
                  onPause={this._onPause.bind(this)}
                  onScreenChange={this._onScreenChange.bind(this)}
                  onPlay={this._onPlay.bind(this)}
                  infinite={this.state.infinite}
                  showBullets={this.state.showBullets}
                  showPlayButton={
                    this.state.showPlayButton &&
                    this.state.showGalleryPlayButton
                  }
                  showThumbnails={this.state.showThumbnails}
                  showIndex={this.state.showIndex}
                  showNav={this.state.showNav}
                  isRTL={this.state.isRTL}
                  thumbnailPosition={this.state.thumbnailPosition}
                  slideDuration={parseInt(this.state.slideDuration)}
                  slideInterval={parseInt(this.state.slideInterval)}
                  slideOnThumbnailOver={this.state.slideOnThumbnailOver}
                  additionalClass="app-image-gallery"
                /> */}
              </CardBody>
            </ModalBody>
            <br />
            <ModalFooter>
              <Button
                color="secondary"
                onClick={() => this.handleCancelVidio()}
              >
                Close
              </Button>{" "}
            </ModalFooter>
          </Modal>
        </Card>

        {/* <ExportCSVTable /> */}
      </Container>
    );
  }
}

export default Leaves;
