import React,{ PureComponent } from "react";
import { Link } from "react-router-dom";
import * as myConstClass from '../../constant.js';
import "react-datepicker/dist/react-datepicker.css";
import './datepicker.scss';
import dateFormat from 'dateformat';

import {
  Breadcrumb,
  BreadcrumbItem, Row,Label,
  Card,
  CardBody,
  CardHeader,
  Container
  ,
} from "reactstrap";

import Header from "../../components/Header";
import HeaderTitle from "../../components/HeaderTitle";
 
import BootstrapTable from "react-bootstrap-table-next";
import ToolkitProvider from "react-bootstrap-table2-toolkit";
import paginationFactory from "react-bootstrap-table2-paginator";
import 'react-confirm-alert/src/react-confirm-alert.css'; // Import css
import {
  AvForm,
  AvGroup,
  AvInput} from "availity-reactstrap-validation";
const tableColumns = [ 
    
  {
    dataField: "employee_id",
    text: "Employee",
    sort: true,
    headerStyle: { width:"10%" }
  },
  {
    dataField: "from_date",
    text: "From Date",
    sort: true,
    headerStyle: { width:"10%" }
  },
  {
    dataField: "to_date",
    text: "To Date",
    sort: true,
    headerStyle: { width:"10%" }
  },
  {
    dataField: "leave_type_id",
    text: "Leave Type",
    sort: true,
    headerStyle: { width:"10%" } 
  },
  {
    dataField: "total_days",
    text: "Total Days",
    sort: true,
    headerStyle: { width:"10%" }
  },
  {
    dataField: "reason",
    text: "Reason",
    sort: true,
    headerStyle: { width:"10%" }
  },
  {
    dataField: "status",
    text: "Status",
    sort: true,
    headerStyle: { width:"10%" }
  },
];


const MyExportCSV = props => {
    const handleClick = () => {
      props.onExport();
    };
    return (
      <div>
          <button className="btn btn-secondary mt-2" onClick={handleClick}>
          Export
        </button>
      </div>
      
    );
  }; 

  class Leaves extends PureComponent {
    constructor(props) {
      super(props);
      this.routeChange = this.routeChange.bind(this);
      //this.googleTranslateElementInit = this.googleTranslateElementInit.bind(this);
     
      this.state = {
       
        formData:'',
        timeOut: 5000,
        showCloseButton: true,
        progressBar: true,
        position: "top-right"
      }
     

    //   submitted: false,
    }

 



  
      routeChange() {
        this.props.history.push('/');
      }

    
      componentDidMount(){

    //     window.googleTranslateElementInit = this.googleTranslateElementInit;
    //     const google = window.google;
    // const script = document.createElement("script");
    // script.src = "//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit";
    // script.async = true;
    // document.body.appendChild(script);  

        document.querySelector('.react-bootstrap-table').style.minHeight  = "243px";
        var admin_id= localStorage.getItem('uname'); 
        if(admin_id == null){
          this.routeChange();
        } 
        var fdate = dateFormat(this.state.from_date,'yyyy-mm-dd');
        var tdate = dateFormat(this.state.to_date,'yyyy-mm-dd');
        fetch(myConstClass.BASE_URL+'attendance/getLeavesArchieved/'+admin_id)
      .then(response => response.json())
      .then(response =>{
      this.setState({formData: response})
    }).catch(err => console.log(err))
    
   
    }

    googleTranslateElementInit () {
      // / eslint-disable no-new /
      const google = window.google;
        new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element');
      new window.google.translate.TranslateElement({pageLanguage: 'pt', layout: window.google.translate.TranslateElement.FloatPosition.TOP_LEFT}, 'google_translate_element')
    }

      render() { 
        var admin_id= localStorage.getItem('uname'); 
        const { emp} = this.state;
        const { org} = this.state;

        const csvColumns= this.csvColumns;
        const csvData =this.state.formData;
       let fileName = 'Employees_Leaves'+new Date().getTime()+'.csv';
       let tableData;


        // var admin_id= localStorage.getItem('uname'); 
        return(
      <Container fluid>
        <Header><div  id="google_translate_element"></div><br/>
          <HeaderTitle>Archieved Leave List</HeaderTitle>
    
          <Breadcrumb>
            <BreadcrumbItem>
              <Link to="/dashboard">Dashboard</Link>
            </BreadcrumbItem>
            {/* <BreadcrumbItem>
              <Link to="/dashboard">measures</Link>
            </BreadcrumbItem> */}
            <BreadcrumbItem>
                <Link to="/leaves/listing">Leave List</Link>
              </BreadcrumbItem>
           
          </Breadcrumb>
        </Header>
        <Card>
        <AvForm id="sform">
         <Row className="f_class_leave">
         <div class="col-md-4"></div>
          <div class="col-md-4"></div>
              
            </Row>
           </AvForm><br/>
          <ToolkitProvider
            keyField="name"
            data={this.state.formData}
            columns={tableColumns}
            exportCSV
          >
            {props => (
              <div>
                <CardHeader>
                  {/* <div className="float-right pull-right"> */}
                   
                  {/* <div class="float-right pull-right" style={{ left: '398px',top: '-21px'}}>
                    <CsvDownloader
                    className="csv"
                    style={{float:'right',backgroundColor:"#4B0082"}}
                    filename={fileName}
                      columns={csvColumns}
                      datas={csvData}
                    text="Export" /></div> */}


                    {/* <MyExportCSV {...props.csvProps} />
                  </div><br/> */}
                  {/* <CardTitle tag="h5">Export CSV</CardTitle>
                  <h6 className="card-subtitle text-muted">
                    Exportable CSV by react-bootstrap-table2
                  </h6> */}
                </CardHeader>
                <CardBody>
                <AvForm id="pform" onValidSubmit={this.handleValidSubmit}>
               
               {/* With AvGroup AvInput and AvFeedback to build your own */}
              
           <Row>
           <div class="col-md-4">
           <Label for="example" className="search_title"></Label>
           <MyExportCSV {...props.csvProps} />
           </div>
             <div class="col-md-4"></div>
              <div class="col-md-4">
                <AvGroup>
                  <Label for="example" className="search_title">Search</Label>
                  <AvInput name="search" className="search" onChange={this.search} type="text" id="example"/>
                </AvGroup>
              </div>
            </Row>
           </AvForm><br/>
                  <BootstrapTable
                    {...props.baseProps}
                    bootstrap4
                    bordered={false}
                    pagination={paginationFactory({
                      // sizePerPage: 25,
                      sizePerPage: 10,
                      sizePerPageList: [5, 10, 25, 50]
                    })}
                  />
                </CardBody>
              </div>
            )}
          </ToolkitProvider>
        </Card>
        
        {/* <ExportCSVTable /> */} 
      </Container>
        );
    }


}

export default Leaves;