import React, { PureComponent } from "react";
import { Link } from "react-router-dom";
import TimePicker from "react-time-picker";
import "react-datepicker/dist/react-datepicker.css";
import "./datepicker.scss";
import Select from "react-select";
import {
  Breadcrumb,
  BreadcrumbItem,
  Row,
  Col,
  Card,
  CardBody,
  Container,
  Button,
  Label,
  FormGroup,
  CustomInput,
} from "reactstrap";

import Header from "../../components/Header";
import HeaderTitle from "../../components/HeaderTitle";

import * as myConstClass from "../../constant.js";
import $ from "jquery";
import { toastr } from "react-redux-toastr";
import {
  AvForm,
  AvField,
  AvGroup,
  AvInput,
  AvFeedback,
} from "availity-reactstrap-validation";

import { T, Config, TF } from "react-translator-component";
Config.default = localStorage.getItem("lang");

const residentOp = [
  { value: "0", label: T("Sunday") },
  { value: "1", label: T("Monday") },
  { value: "2", label: T("Tuesday") },
  { value: "3", label: T("Wednesday") },
  { value: "4", label: T("Thursday") },
  { value: "5", label: T("Friday") },
  { value: "6", label: T("Saturday") },
  //{ value: '7', label: T('Any') }
];

class Validation extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      tuesday_readOnly: false,
      wednesday_readOnly: false,
      thursday_readOnly: false,
      friday_readOnly: false,
      saturday_readOnly: false,
      sunday_readOnly: false,
    };
    this.routeChange = this.routeChange.bind(this);
    this.handleCheckChange = this.handleCheckChange.bind(this);
    this.onMondayInTimeChange = this.onFridayInTimeChange.bind(this);
    // this.onMondayRestTimeChange = this.onMondayRestTimeChange(this);
    // state = {
    //   startDate: new Date()
    // };
    this.state = {
      user_id: "0",
      code: "",
      resident: "",
      units: "",
      org: "",
      day_off: "",
      pay_codes: "",
      days_group: [],
      day_title: [],
      monday_rest: "",
      time: "10:00",
      timezones: "",
      formData: {
        shift_name: "",
        //shift_code: '',
        monday_in_time: "",
        monday_out_time: "",
        tuesday_in_time: "",
        tuesday_out_time: "",
        wednesday_in_time: "",
        wednesday_out_time: "",
        thursday_in_time: "",
        thursday_out_time: "",
        friday_in_time: "",
        friday_out_time: "",
        saturday_in_time: "",
        saturday_out_time: "",
        sunday_in_time: "",
        sunday_out_time: "",
        monday_total_rest: "",
        tuesday_total_rest: "",
        wednesday_total_rest: "",
        wednesday_total_rest: "",
        thursday_total_rest: "",
        friday_total_rest: "",
        saturday_total_rest: "",
        sunday_total_rest: "",
        sunday_pay_code: "",
        day_off: "",
      },
      submitted: false,
      timeOut: 5000,
      showCloseButton: true,
      progressBar: true,
      position: "top-right",
    };

    this.options = {
      timeOut: parseInt(this.state.timeOut),
      showCloseButton: this.state.showCloseButton,
      progressBar: this.state.progressBar,
      position: this.state.position,
    };
  }

  onMondayInTimeChange = (monday_in_time) => {
    // alert('hii');
    // alert(monday_in_time);
    this.setState({ monday_in_time });
    //this.setState({ formData.monday_in_time:monday_in_time })
    if (monday_in_time) {
      $(".monday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".monday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
  onMondayOutTimeChange = (monday_out_time) => {
    this.setState({ monday_out_time });
    if (monday_out_time) {
      $(".monday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".monday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
  // onMondayRestTimeChange = event => this.setState({ monday_total_rest: event.target.value })
 
  onTuesdayInTimeChange = (tuesday_in_time) => {
    this.setState({ tuesday_in_time });
    if (tuesday_in_time) {
      $(".tuesday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".tuesday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
  onTuesdayOutTimeChange = (tuesday_out_time) => {
    this.setState({ tuesday_out_time });

    if (tuesday_out_time) {
      $(".tuesday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".tuesday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };

  // onTuesdayRestTimeChange = tuesday_total_rest => this.setState({ tuesday_total_rest })


  onWednesdayInTimeChange = (wednesday_in_time) => {
    this.setState({ wednesday_in_time });
    if (wednesday_in_time) {
      $(".wednesday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".wednesday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
  onWednesdayOutTimeChange = (wednesday_out_time) => {
    this.setState({ wednesday_out_time });
    if (wednesday_out_time) {
      $(".wednesday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".wednesday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
 
  onThursdayInTimeChange = (thursday_in_time) => {
    this.setState({ thursday_in_time });
    if (thursday_in_time) {
      $(".thursday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".thursday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
  onThursdayOutTimeChange = (thursday_out_time) => {
    this.setState({ thursday_out_time });
    if (thursday_out_time) {
      $(".thursday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".thursday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
 

  onFridayInTimeChange = (friday_in_time) => {
    this.setState({ friday_in_time });

    if (friday_in_time) {
      $(".friday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".friday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
  onFridayOutTimeChange = (friday_out_time) => {
    this.setState({ friday_out_time });
    if (friday_out_time) {
      $(".friday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".friday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };


  onSaturdayInTimeChange = (saturday_in_time) => {
    this.setState({ saturday_in_time });
    if (saturday_in_time) {
      $(".saturday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".saturday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
  onSaturdayOutTimeChange = (saturday_out_time) => {
    this.setState({ saturday_out_time });
    if (saturday_out_time) {
      $(".saturday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".saturday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
  onSaturdayRestTimeChange = (saturday_total_rest) =>
    this.setState({ saturday_total_rest });

  onSundayInTimeChange = (sunday_in_time) => {
    this.setState({ sunday_in_time });

    if (sunday_in_time) {
      $(".sunday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".sunday_in_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };
  onSundayOutTimeChange = (sunday_out_time) => {
    this.setState({ sunday_out_time });

    if (sunday_out_time) {
      $(".sunday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "hsl(0,0%,80%)");
    } else {
      $(".sunday_out_time")
        .children(".react-time-picker__wrapper")
        .css("border-color", "#dc3545");
    }
  };

  handleCheckChange() {
    //alert(this.state.monday_total_rest);
    this.setState({
      checked: !this.state.checked,
    });

    var arr = [];
    var j = 0;

    var jsonStr = JSON.stringify(this.state.days_group, null, 2);
    var obj = JSON.parse(jsonStr);
    if (this.state.days_group != null) {
      for (var i = 0; i < obj.length; i++) {
        arr[j++] = obj[i].value;
      }
    }
    //  alert(!arr.includes('2'));
    if (!this.state.checked) {
      const { formData } = this.state;
      // for tuesday
      let montotal_rest;
      if (formData && !this.state.monday_total_rest) {
        montotal_rest = formData.monday_total_rest;
      } else {
        montotal_rest = this.state.monday_total_rest;
      }

      fetch(myConstClass.BASE_URL + "shifts/getMondayVal/" + montotal_rest)
        .then((response) => response.json())
        .then((response) => {
          this.setState({ monday_rest: response });
        })
        .catch((err) => console.log(err));

      // if(!arr.includes('2')==true)
      // {
      //   //alert();
      // this.setState({ tuesday_in_time: this.state.monday_in_time })
      // this.setState({ tuesday_out_time: this.state.monday_out_time })
      // this.setState({ tuesday_pay_code : this.state.monday_pay_code })
      // this.setState({tuesday_total_rest: this.state.monday_total_rest})
      // this.setState({ tuesday_readOnly: true })
      // }

      // for wednesday

      this.setState({ tuesday_in_time: this.state.monday_in_time });
      this.setState({ tuesday_out_time: this.state.monday_out_time });
      this.setState({ tuesday_pay_code: this.state.monday_pay_code });
      this.setState({ tuesday_total_rest: this.state.monday_total_rest });
      this.setState({ tuesday_readOnly: true });

      this.setState({ wednesday_in_time: this.state.monday_in_time });
      this.setState({ wednesday_out_time: this.state.monday_out_time });
      this.setState({ wednesday_pay_code: this.state.monday_pay_code });
      this.setState({ wednesday_total_rest: this.state.monday_total_rest });
      this.setState({ wednesday_readOnly: true });

      // for thursday
      this.setState({ thursday_in_time: this.state.monday_in_time });
      this.setState({ thursday_out_time: this.state.monday_out_time });
      this.setState({ thursday_total_rest: this.state.monday_total_rest });
      this.setState({ thursday_pay_code: this.state.monday_pay_code });
      this.setState({ thursday_readOnly: true });

      // for friday
      this.setState({ friday_in_time: this.state.monday_in_time });
      this.setState({ friday_out_time: this.state.monday_out_time });
      this.setState({ friday_total_rest: this.state.monday_total_rest });
      this.setState({ friday_pay_code: this.state.monday_pay_code });
      this.setState({ friday_readOnly: true });

      // for saturday
      this.setState({ saturday_in_time: this.state.monday_in_time });
      this.setState({ saturday_out_time: this.state.monday_out_time });
      this.setState({ saturday_total_rest: this.state.monday_total_rest });
      this.setState({ saturday_pay_code: this.state.monday_pay_code });
      this.setState({ saturday_readOnly: true });

      // for sunday
      this.setState({ sunday_in_time: this.state.monday_in_time });
      this.setState({ sunday_out_time: this.state.monday_out_time });
      this.setState({ sunday_total_rest: this.state.monday_total_rest });
      this.setState({ sunday_pay_code: this.state.monday_pay_code });
      this.setState({ sunday_readOnly: true });
    } else {
      this.setState({ tuesday_readOnly: false });
      this.setState({ wednesday_readOnly: false });
      this.setState({ thursday_readOnly: false });
      this.setState({ friday_readOnly: false });
      this.setState({ saturday_readOnly: false });
      this.setState({ sunday_readOnly: false });
    }
  }

  routeChange() {
    this.props.history.push("/");
  }
  componentDidMount() {
    var admin_id = localStorage.getItem("uname");
    var login_type = localStorage.getItem("login_type");
    if (admin_id == null) {
      this.routeChange();
    }
    const answer_array = this.props.location.pathname.split("/");
    //alert(answer_array['3']);
    if (answer_array) {
      this.state.user_id = this.props.location.state._id;
      fetch(myConstClass.BASE_URL + "shifts/getShiftInfo/" + this.state.user_id)
        .then((response) => response.json())
        .then((response) => {
          this.setState({ shift_code: response.shift_code });

          this.setState({
            monday_pay_code: [
              {
                value: response.monday_pay_code,
                label: response.monday_pay_code_title,
              },
            ],
          });
          this.setState({
            tuesday_pay_code: [
              {
                value: response.tuesday_pay_code,
                label: response.tuesday_pay_code_title,
              },
            ],
          });
          this.setState({
            wednesday_pay_code: [
              {
                value: response.wednesday_pay_code,
                label: response.wednesday_pay_code_title,
              },
            ],
          });
          this.setState({
            thursday_pay_code: [
              {
                value: response.thursday_pay_code,
                label: response.thursday_pay_code_title,
              },
            ],
          });
          this.setState({
            friday_pay_code: [
              {
                value: response.friday_pay_code,
                label: response.friday_pay_code_title,
              },
            ],
          });
          this.setState({
            saturday_pay_code: [
              {
                value: response.saturday_pay_code,
                label: response.saturday_pay_code_title,
              },
            ],
          });
          this.setState({
            sunday_pay_code: [
              {
                value: response.sunday_pay_code,
                label: response.sunday_pay_code_title,
              },
            ],
          });

          // if(response.negativebalance == 1){
          //   this.setState({
          //     checked: !this.state.checked
          //   })
          // }

          fetch(
            myConstClass.BASE_URL +
              "shifts/getEmployeeShiftSayOffInfo/" +
              this.state.user_id
          )
            .then((response) => response.json())
            .then((response) => {
              response.map(() => {
                this.setState({ days_group: response });
                // return( value: cell.TimeZone, label: cell.TimeZone+'(UTC '+cell.UTC_offset+')' }
              });
              // response.forEach(element => { alert(element.id+' '+element.title);
              //   let id=element.id;
              //   let name=element.title;
              //   this.setState({employee_group:[{ value:id, label:name}]});
              //  // console.log(element);
              //  element.id = i;
              //  i++;
              // });

              var arr = [];
              var j = 0;

              var jsonStr = JSON.stringify(response, null, 2);
              var obj = JSON.parse(jsonStr);

              for (var k = 0; k < obj.length; k++) {
                arr[j++] = obj[k].value;
              }

              for (var c = 0; c < arr.length; c++) {
                $("#" + arr[c]).hide();
              }

              this.setState({ formData_groups: response });
            })
            .catch((err) => console.log(err));

          this.setState({ formData: response });
        })
        .catch((err) => console.log(err));
    }

    // fetch(myConstClass.BASE_URL+'organization/get_all_organizations/'+admin_id)
    // .then(response => response.json())
    // .then(response =>{this.setState({org: response})}).catch(err => console.log(err))

   

      fetch(
        myConstClass.BASE_URL + "organization/get_all_organizations/" + admin_id
      )
        .then((response) => response.json())
        .then((response) => {
          this.setState({ organization: response });
        })
        .catch((err) => console.log(err));
  }

  handleGroupChange = (group) => {
    this.setState({ days_group: group });
    var jsonStr = JSON.stringify(group, null, 2);
    var obj = JSON.parse(jsonStr);

    //var val = obj[0].value;

    var arr = [];
    var arr1 = [];
    var j = 0,
      m = 0;
    if (group != null) {
      for (var i = 0; i < obj.length; i++) {
        arr[j++] = obj[i].value;
      }
    }
    // else
    // {
    //   $('#0').show();
    // }

    for (var k = 0; k <= 6; k++) {
      arr1[m++] = k;
    }

    for (var i = 0; i < arr1.length; i++) {
      //alert(arr1[i]);alert(arr[i]);
      for (var j = 0; j < arr.length; j++) {
        if (arr1[i] == arr[j]) {
          //delete arr1[i];
          arr1.splice(i, 1);
        }
      }
    }

    // alert(arr);

    // //arr3=arrayDiff(arr,arr1);
    // // alert(arr.filter(d => !arr1.includes(d)));
    // //arr3=arr1.filter(x => arr.indexOf(x) === -1);

    // var newArr = [];
    // var myArr = arr.concat(arr1);

    //   newArr = myArr.filter(function(item){
    //     return arr.indexOf(item) < 0 || arr1.indexOf(item) < 0;
    //   });

    //   alert(newArr);

    for (var c = 0; c < arr.length; c++) {
      $("#" + arr[c]).hide();
    }
    for (var d = 0; d < arr1.length; d++) {
      $("#" + arr1[d]).show();
    }
  };

  handleChange = (attendance_date) => {
    this.setState({ attendance_date });
  };

  handleSubmit = () => {
    // var arr = [];
    // var j = 0, k = 0;
    // var jsonStr = JSON.stringify(this.state.days_group, null, 2);
    // var obj = JSON.parse(jsonStr);
    // if (this.state.days_group != null) {
    //   for (var i = 0; i < obj.length; i++) {
    //     arr[j++] = obj[i].value;
    //   }
    // }
    // if (this.state.user_id == '0') {
    //   //    alert("Hii");
    //   if (!arr.includes("0")) {
    //     if (this.state.sunday_in_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.sunday_in_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.sunday_out_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.sunday_out_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.sunday_pay_code == undefined) {
    //       $("#sunday_pay_code").children(".css-yk16xz-control").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     let text = $("#sunday_total_rest").val();
    //     const myArray = text.split(":");
    //     //  alert(myArray);
    //     let word1 = myArray[0];
    //     let word = myArray[1];
    //     if (myArray != '') {
    //       if (word1 > 23) {
    //         k++;
    //       }
    //       if (word > 59) {
    //         k++;
    //       }
    //     }
    //     else {
    //       $("#sunday_total_rest").addClass("is-invalid1");
    //       k++;
    //     }
    //   }
    //   if (!arr.includes("2")) {
    //     if (this.state.tuesday_in_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.tuesday_in_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.tuesday_out_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.tuesday_out_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.tuesday_pay_code == undefined) {
    //       $("#tuesday_pay_code").children(".css-yk16xz-control").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     let text = $("#tuesday_total_rest").val();
    //     const myArray = text.split(":");
    //     //  alert(myArray);
    //     let word1 = myArray[0];
    //     let word = myArray[1];
    //     if (myArray != '') {
    //       if (word1 > 23) {
    //         k++;
    //       }
    //       if (word > 59) {
    //         k++;
    //       }
    //     }
    //     else {
    //       $("#tuesday_total_rest").addClass("is-invalid1");
    //       k++;
    //     }
    //   }
    //   if (!arr.includes("3")) {
    //     if (this.state.wednesday_in_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.wednesday_in_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.wednesday_out_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.wednesday_out_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.wednesday_pay_code == undefined) {
    //       $("#wednesday_pay_code").children(".css-yk16xz-control").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     let text = $("#wednesday_total_rest").val();
    //     const myArray = text.split(":");
    //     //  alert(myArray);
    //     let word1 = myArray[0];
    //     let word = myArray[1];
    //     if (myArray != '') {
    //       if (word1 > 23) {
    //         k++;
    //       }
    //       if (word > 59) {
    //         k++;
    //       }
    //     }
    //     else {
    //       $("#wednesday_total_rest").addClass("is-invalid1");
    //       k++;
    //     }
    //   }
    //   if (!arr.includes("4")) {
    //     if (this.state.thursday_in_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.thursday_in_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.thursday_out_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.thursday_out_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.thursday_pay_code == undefined) {
    //       $("#thursday_pay_code").children(".css-yk16xz-control").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     let text = $("#thursday_total_rest").val();
    //     const myArray = text.split(":");
    //     //  alert(myArray);
    //     let word1 = myArray[0];
    //     let word = myArray[1];
    //     if (myArray != '') {
    //       if (word1 > 23) {
    //         k++;
    //       }
    //       if (word > 59) {
    //         k++;
    //       }
    //     }
    //     else {
    //       $("#thursday_total_rest").addClass("is-invalid1");
    //       k++;
    //     }
    //   }
    //   if (!arr.includes("5")) {
    //     if (this.state.friday_in_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.friday_in_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.friday_out_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.friday_out_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.friday_pay_code == undefined) {
    //       $("#friday_pay_code").children(".css-yk16xz-control").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     let text = $("#friday_total_rest").val();
    //     const myArray = text.split(":");
    //     //  alert(myArray);
    //     let word1 = myArray[0];
    //     let word = myArray[1];
    //     if (myArray != '') {
    //       if (word1 > 23) {
    //         k++;
    //       }
    //       if (word > 59) {
    //         k++;
    //       }
    //     }
    //     else {
    //       $("#friday_total_rest").addClass("is-invalid1");
    //       k++;
    //     }
    //   }
    //   if (!arr.includes("6")) {
    //     if (this.state.saturday_in_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.saturday_in_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.saturday_out_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.saturday_out_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.saturday_pay_code == undefined) {
    //       $("#saturday_pay_code").children(".css-yk16xz-control").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     let text = $("#saturday_total_rest").val();
    //     const myArray = text.split(":");
    //     //  alert(myArray);
    //     let word1 = myArray[0];
    //     let word = myArray[1];
    //     if (myArray != '') {
    //       if (word1 > 23) {
    //         k++;
    //       }
    //       if (word > 59) {
    //         k++;
    //       }
    //     }
    //     else {
    //       $("#saturday_total_rest").addClass("is-invalid1");
    //       k++;
    //     }
    //   }
    //   if (!arr.includes("1")) {
    //     if (this.state.monday_in_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.monday_in_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.monday_out_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.monday_out_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.monday_pay_code == undefined) {
    //       $("#monday_pay_code").children(".css-yk16xz-control").css("border-color", "#dc3545");
    //       k++;
    //     }
    //   }
    //   let text = $("#monday_total_rest").val();
    //   const myArray = text.split(":");
    //   //  alert(myArray);
    //   let word1 = myArray[0];
    //   let word = myArray[1];
    //   if (myArray != '') {
    //     if (word1 > 23) {
    //       k++;
    //     }
    //     if (word > 59) {
    //       k++;
    //     }
    //   }
    //   else {
    //     $("#monday_total_rest").addClass("is-invalid1");
    //     // $("#selectIDElabel").css("color", "#dc3545");
    //     // $("#selectIDE").children(".css-yk16xz-control").css( "border-color", "#dc3545" );
    //     // $("#selectIDEs").show();
    //     k++;
    //   }
    // }
    // if (k !== 0) {
    //   return;
    // }
  };

  handleValidSubmit = () => {
    // var arr = [];
    // var j = 0, k = 0;

    // var jsonStr = JSON.stringify(this.state.days_group, null, 2);
    // var obj = JSON.parse(jsonStr);
    // if (this.state.days_group != null) {
    //   for (var i = 0; i < obj.length; i++) {

    //     arr[j++] = obj[i].value;

    //   }
    // }
    // // alert(this.state.days_group);

    // if (this.state.user_id == '0') {

    //   if (!arr.includes("0")) {
    //     if (this.state.sunday_in_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.sunday_in_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     if (this.state.sunday_out_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.sunday_out_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }

    //     if (this.state.sunday_pay_code == undefined) {
    //       $("#sunday_pay_code").children(".css-yk16xz-control").css("border-color", "#dc3545");
    //       k++;
    //     }
    //     let text = $("#sunday_total_rest").val();
    //     const myArray = text.split(":");
    //     //  alert(myArray);
    //     let word1 = myArray[0];
    //     let word = myArray[1];
    //     if (myArray != '') {
    //       if (word1 > 23) {
    //         alert();
    //         return;
    //       }
    //       if (word > 59) {
    //         alert();
    //         return;
    //       }
    //     }
    //     else {
    //       $("#sunday_total_rest").addClass("is-invalid1");
    //       // $("#selectIDElabel").css("color", "#dc3545");
    //       // $("#selectIDE").children(".css-yk16xz-control").css( "border-color", "#dc3545" );
    //       // $("#selectIDEs").show();
    //       return;
    //     }

    //   }

    //   if (!arr.includes("1")) {
    //     if (this.state.monday_in_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.monday_in_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }

    //     if (this.state.monday_out_time == undefined) {
    //       // $('input[name="sunday_out_time"]').css("border-color", "blue");
    //       $('.monday_out_time').children(".react-time-picker__wrapper").css("border-color", "#dc3545");
    //       k++;
    //     }

    //     if (this.state.monday_pay_code == undefined) {
    //       $("#monday_pay_code").children(".css-yk16xz-control").css("border-color", "#dc3545");
    //       k++;
    //     }

    //   }
    //   let text = $("#monday_total_rest").val();
    //   const myArray = text.split(":");
    //   //  alert(myArray);
    //   let word1 = myArray[0];
    //   let word = myArray[1];
    //   if (myArray != '') {
    //     if (word1 > 23) {
    //       k++;
    //     }
    //     if (word > 59) {
    //       k++;
    //     }
    //   }
    //   else {
    //     $("#monday_total_rest").addClass("is-invalid1");
    //     // $("#selectIDElabel").css("color", "#dc3545");
    //     // $("#selectIDE").children(".css-yk16xz-control").css( "border-color", "#dc3545" );
    //     // $("#selectIDEs").show();
    //     k++;
    //   }

    // }

    // if (k !== 0) {

    //   return;
    // }

    var admin_id = localStorage.getItem("uname");
    this.setState({ submitted: true }, () => {
      //setTimeout(() => this.setState({ submitted: false }), 5000);


      if(this.state.shift_code!='')
      {
      fetch(
        myConstClass.BASE_URL +
          `shifts/add_shift/` +
          admin_id +
          "/" +
          this.state.user_id,
        {
          method: "POST",
          body: JSON.stringify($("#pform").serializeArray()),
        }
      )
        .then((response) => response.json())
        .then((response) => {
          this.setState({ submitted: false });
          if (response) {


            if (response=='ERR01') {
            this.setState({ shift_code: "" });  
            toastr.error(
              TF("{0}", T("Error")),
              TF("{0}...!", T("Code Already Present")),
              this.options
            );
          }else{



            this.state.user_id == "0"
              ? toastr.success(
                  TF("{0}", T("Success")),
                  TF(
                    "{0} {1} {2}...!",
                    T("Shift"),
                    T("Added"),
                    T("Successfully")
                  ),
                  this.options
                )
              : toastr.success(
                  TF("{0}", T("Success")),
                  TF(
                    "{0} {1} {2}...!",
                    T("Shift"),
                    T("Updated"),
                    T("Successfully")
                  ),
                  this.options
                );

            this.props.history.push(
              "/" + "shifts/listing"
            );
          }
          } else {
            toastr.error(
              TF("{0}", T("Error")),
              TF("{0} {1} {2}...!", T("Can"), T("not"), T("Add"), T("Shift")),
              this.options
            );
          }
        })
        .catch();
      }
      else
      {
        toastr.error(
          TF("{0}", T("Error")),
          TF("{0} {1} {2}...!", T("Please"), T("Add"), T("Shift"), T("Code")),
          this.options
        );
      }

    });
  };
  compareToShortCode = (e, callback) => {
    this.setState({ shift_code: e.target.value });

    // fetch(
    //   myConstClass.BASE_URL + "/shifts/getShiftcode/" + e.target.value + "/" + 0
    // )
    //   .then((response) => response.json())
    //   .then((response) => {
    //     //this.setState({state: response})
    //     //alert(response.value1);
    //     if (response.result) {
    //       //alert('hii');
    //       //callback();
    //     } else {
    //       this.setState({ shift_code: "" });
    //       // alert("Job Id Already Available");
    //       toastr.error(
    //         TF("{0}", T("Error")),
    //         TF("{0}...!", T("Code Already Present")),
    //         this.options
    //       );

    //       //();
    //       // $("#question").value("Your text goes here");

    //       return;
    //     }
    //   });

    //this.setState({confirmDirty: this.state.confirmDirty || !!value});
  };

  render() {
    const { formData, submitted } = this.state;
    const {
      org,
      monday_rest,
      pay_codes,
      organization,
    } = this.state;

    var login_type = localStorage.getItem("login_type");
    let payCodeOp = pay_codes
      ? pay_codes.map((cell) => {
          return { value: cell.id, label: cell.title };
          // return( value: cell.TimeZone, label: cell.TimeZone+'(UTC '+cell.UTC_offset+')' }
        })
      : [];

    let tue_total_rest;
    let wed_total_rest;
    let thu_total_rest;
    let fri_total_rest;
    let sat_total_rest;
    let sun_total_rest;

    if (monday_rest) {
      tue_total_rest = monday_rest.monday_total_rest;
      wed_total_rest = monday_rest.monday_total_rest;
      thu_total_rest = monday_rest.monday_total_rest;
      fri_total_rest = monday_rest.monday_total_rest;
      sat_total_rest = monday_rest.monday_total_rest;
      sun_total_rest = monday_rest.monday_total_rest;
    } else {
      tue_total_rest = formData ? formData.tuesday_total_rest : "";
      wed_total_rest = formData ? formData.wednesday_total_rest : "";
      thu_total_rest = formData ? formData.thursday_total_rest : "";
      fri_total_rest = formData ? formData.friday_total_rest : "";
      sat_total_rest = formData ? formData.saturday_total_rest : "";
      sun_total_rest = formData ? formData.sunday_total_rest : "";
    }

    return (
      <Container fluid>
        <Header>
          <HeaderTitle>
            {this.state.user_id != "0" ? T("Edit") : T("Add")}
          </HeaderTitle>
          <Breadcrumb>
            <BreadcrumbItem>
              <Link to={"/" + "dashboard"}>
                {T("Dashboard")}
              </Link>
            </BreadcrumbItem>
            <BreadcrumbItem>
              <Link to={"/" + "shifts/listing"}>
                {" "}
                {T("All")} {T("Shift")} 
              </Link>
            </BreadcrumbItem>
            <BreadcrumbItem active>
              {this.state.user_id != "0" ? T("Edit") : T("Add")}
            </BreadcrumbItem>
          </Breadcrumb>
        </Header>
        <Card>
          <CardBody>
            <AvForm
              id="pform"
              onSubmit={this.handleSubmit}
              onValidSubmit={this.handleValidSubmit}
            >
              <h4>
                {T("Shift")}
                <span
                  style={{ color: "red", fontSize: "14px", float: "right" }}
                >
                  {" "}
                  {T("All fields marked with * are required")}{" "}
                </span>
              </h4>
              <hr />
              <Row>
              <Col lg={6}>
                  <AvGroup>
                    {/* <AvInput name="employee_id" id="example" required value={formData ? formData.employee_id:''}/>
                  <AvFeedback>Enter Employee ID!</AvFeedback> */}
                    <AvField
                      type="select"
                      name="organization_id"
                      required
                      label="Select Organization"
                      value={formData ? formData.organization_id : ""}
                    >
                      <option value="">Select Organization</option>
                      {organization
                        ? organization.map((cell, i) => {
                            return (
                              <option value={cell.id}>{cell.title}</option>
                            );
                          })
                        : ""}
                    </AvField>
                  </AvGroup>
                </Col>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      {" "}
                      {TF("{0} {1}", T("Shift"), T("Name"))}
                    </Label>
                    <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    <AvInput
                      name="shift_name"
                      id="example"
                      placeholder={TF("{0} {1}", T("Shift"), T("Name"))}
                      required
                      value={formData ? formData.shift_name : ""}
                    />
                    <AvFeedback>
                      {TF("{0} {1} {2}", T("Enter"), T("Shift"), T("Name"))}
                    </AvFeedback>
                  </AvGroup>
                </Col>
              </Row>
              <Row>
                <Col lg={6}>
                  <AvGroup>
                    <Label for="example">
                      {TF("{0} {1}", T("Shift"), T("Code"))}
                    </Label>
                    <span style={{ color: "red", fontSize: "15px" }}> *</span>
                    <AvInput
                      name="shift_code"
                      id="example"
                      placeholder={TF("{0} {1}", T("Shift"), T("Code"))}
                      required
                      value={this.state.shift_code}
                      onBlur={this.compareToShortCode}
                    />
                    <AvFeedback>
                      {TF("{0} {1} {2}", T("Enter"), T("Shift"), T("Code"))}
                    </AvFeedback>
                  </AvGroup>
                </Col>
                {/* <Col lg={6}>
               
                  <Label for="example">  {TF("{0} {1}", T("Day"), T("Off"))}</Label>
                  <Select
                    value={days_group}
                    name="days_group"
                    placeholder={TF("{0} {1} {2}", T("Select"), T("Day"), T("Off"))}
                    options={residentOp}
                    onChange={this.handleGroupChange}
                    isMulti
                
                  />
                
                </Col> */}
              </Row>
              <br />
              <h6 style={{ color: "black" }}>
                {T("NOTE: In Time and Out Time in 24 Hrs Format")}
              </h6>
              {/* for monday */}
              <Row id="1">
                <Col lg={4}>
                  <Label for="example">{TF("{0}", T("Day"))}</Label>
                  <br /> <Label for="example">{TF("{0}", T("Monday"))}</Label>
                  {/* <CustomInput
                    type="checkbox"
                    name="apply_to_all"
                    id="exampleCustomCheckbox"
                    label={TF("{0} {1} {2}", T("Apply"), T("To"), T("All"))}

                    className="mb-2"
                    checked={this.state.checked}
                    onChange={this.handleCheckChange}
                  /> */}
                  <br />{" "}
                </Col>
                {/* <Col lg={2}>
                  <Label for="example">{TF("{0}", T("In-Time"))}</Label> <br />
                  {(this.state.user_id != '0') ?
                    <AvGroup>
                      <TimePicker
                        locale="sv-sv"
                        className='monday_in monday_in_time'
                        name="monday_in_time"
                        onChange={this.onMondayInTimeChange}
                        required
                        onCancel={() => this.setState({ monday_in_time: false })}
                        value={this.state.monday_in_time || formData.monday_in_time}
                      />
                      <AvFeedback>{TF("{0} {1}..... !", T("Enter"), T("Title"))}</AvFeedback>
                    </AvGroup>
                    :
                    <AvGroup>
                      <TimePicker
                        locale="sv-sv"
                        name="monday_in_time"
                        className='monday_in monday_in_time'
                        onChange={this.onMondayInTimeChange}
                        value={monday_in_time}
                        required
                      />
                      <AvFeedback>{TF("{0} {1}..... !", T("Enter"), T("Title"))}</AvFeedback>
                    </AvGroup>

                  }

                </Col>
                <Col lg={2}>
                  <Label for="example">{TF("{0}", T("Out-Time"))}</Label> <br />
                  {(this.state.user_id != '0') ? <TimePicker
                    locale="sv-sv"
                    name="monday_out_time"
                    className='monday_in monday_out_time'
                    onChange={this.onMondayOutTimeChange}
                    value={this.state.monday_out_time || formData.monday_out_time}

                  />
                    :
                    <TimePicker
                      locale="sv-sv"
                      name="monday_out_time"
                      className='monday_in monday_out_time'
                      onChange={this.onMondayOutTimeChange}
                      value={this.state.monday_out_time}

                    />}
                </Col> */}

                <Col lg={4}>
                  <Label for="example">
                    {TF("{0} ({1})", T("In-Time"), T("HH:MM"))}
                  </Label>{" "}
                  <br />
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="monday_in_time"
                      
                      value={formData ? formData.monday_in_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>

                <Col lg={4}>
                  <Label for="example">
                    {TF("{0} ({1})", T("Out-Time"), T("HH:MM"))}
                  </Label>{" "}
                  <br />
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="monday_out_time"
                      
                      value={formData ? formData.monday_out_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>

               
              </Row>
              <br />

              {/* checkbox for applying to all rmainng days */}
              {/* <Row>
              <Col lg={6}>
                <CustomInput
                type="checkbox"
                name = "apply_to_all"
                id="exampleCustomCheckbox"
                label="Apply To All"
      
                className="mb-2"
                checked={ this.state.checked} 
                onChange={ this.handleCheckChange }
            />
             </Col>  
             </Row><br/> */}

              {/* for tuesday */}
              <Row id="2">
                <Col lg={4}>
                  {" "}
                  <Label for="example">{TF("{0}", T("Tuesday"))}</Label>{" "}
                </Col>
                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("In-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="tuesday_in_time"
                      
                      value={formData ? formData.tuesday_in_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>

                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("Out-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="tuesday_out_time"
                      
                      value={formData ? formData.tuesday_out_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>
             
              </Row>
              <br />

              {/* for wednesday */}
              <Row id="3">
                <Col lg={4}>
                  {" "}
                  <Label for="example">{TF("{0}", T("Wednesday"))}</Label>{" "}
                </Col>
                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("In-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="wednesday_in_time"
                      
                      value={formData ? formData.wednesday_in_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>

                <Col lg={4}>
                  {/* ? <Label for="example">{TF("{0} ({1})", T("Out-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="wednesday_out_time"
                      
                      value={formData ? formData.wednesday_out_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>
               
              </Row>
              <br />

              {/* for thursday */}
              <Row id="4">
                <Col lg={4}>
                  {" "}
                  <Label for="example">{TF("{0}", T("Thursday"))}</Label>{" "}
                </Col>
                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("In-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="thursday_in_time"
                      
                      value={formData ? formData.thursday_in_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>

                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("Out-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="thursday_out_time"
                      
                      value={formData ? formData.thursday_out_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>
               
              </Row>
              <br />

              {/* for Friday */}
              <Row id="5">
                <Col lg={4}>
                  {" "}
                  <Label for="example">{TF("{0}", T("Friday"))}</Label>{" "}
                </Col>
                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("In-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="friday_in_time"
                      
                      value={formData ? formData.friday_in_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>

                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("Out-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="friday_out_time"
                      
                      value={formData ? formData.friday_out_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>
              
              </Row>
              <br />

              {/* for saturday */}
              <Row id="6">
                <Col lg={4}>
                  <Label for="example">{TF("{0}", T("Saturday"))}</Label>{" "}
                </Col>
                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("In-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="saturday_in_time"
                      
                      value={formData ? formData.saturday_in_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>

                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("Out-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="saturday_out_time"
                      
                      value={formData ? formData.saturday_out_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>

               
              </Row>
              <br />

              {/* for sunday */}
              <Row id="0">
                <Col lg={4}>
                  {" "}
                  <Label for="example">{TF("{0}", T("Sunday"))}</Label>{" "}
                </Col>
                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("In-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="sunday_in_time"
                      
                      value={formData ? formData.sunday_in_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>

                <Col lg={4}>
                  {/* <Label for="example">{TF("{0} ({1})", T("Out-Time"), T("Hrs"))}</Label> <br /> */}
                  <AvGroup>
                    <AvInput
                      type="time"
                      name="sunday_out_time"
                      
                      value={formData ? formData.sunday_out_time : ""}
                    />
                    {/* <AvFeedback>Enter Monday Total Rest !{TF("{0} {1}..... !", T("Enter") , T("Title"))}</AvFeedback> */}
                  </AvGroup>
                </Col>
              
              </Row>
              <br />

              <Row></Row>
              <br />

              <FormGroup>
                <Link
                  to={"/" + "shifts/listing"}
                  style={{
                    margin: "0rem 1.50rem 1.50rem 0rem",
                    border: "#6f42c1 1px solid",
                    color: "#6f42c1",
                    padding: "0.10rem 0.90rem 0.30rem 0.90rem",
                    textDecoration: "none",
                    borderRadius: "0.2rem",
                  }}
                >
                  {T("Cancel")}
                </Link>
                {this.state.user_id != "0" ? (
                  <Button disabled={submitted}>
                    {(submitted &&
                      TF(
                        "{0} {1} {2} {3}!",
                        T("Your"),
                        T("form"),
                        T("is"),
                        T("submitted")
                      )) ||
                      (!submitted && T("Update"))}
                  </Button>
                ) : (
                  <Button disabled={submitted}>
                    {(submitted &&
                      TF(
                        "{0} {1} {2} {3}!",
                        T("Your"),
                        T("form"),
                        T("is"),
                        T("submitted")
                      )) ||
                      (!submitted && T("Add"))}
                  </Button>
                )}
              </FormGroup>
            </AvForm>
          </CardBody>
        </Card>
      </Container>
    );
  }
}

export default Validation;
