import React ,{ PureComponent } from 'react';
import { Col, Container, Row,Button,ButtonToolbar,Breadcrumb,
  BreadcrumbItem,
  Card,
  CardBody,
  CardHeader,
  CardTitle,FormGroup,
  Label,
  CustomInput

  } from 'reactstrap';
import { Link } from "react-router-dom";
import Header from "../../components/Header";
import HeaderTitle from "../../components/HeaderTitle";
import * as myConstClass from '../../constant.js';
import $ from 'jquery';
import { ValidatorForm, TextValidator } from 'react-material-ui-form-validator';
import { toastr } from "react-redux-toastr";

import {
    AvForm,
    AvField,
    AvGroup,
    AvInput,
    AvFeedback,
    AvRadioGroup,
    AvRadio,
    AvCheckboxGroup,
    AvCheckbox
  } from "availity-reactstrap-validation";

class Signup extends PureComponent {
  constructor(props) {
    super(props);
    //this.googleTranslateElementInit = this.googleTranslateElementInit.bind(this);
    this.handleHrReq = this.handleHrReq.bind(this);
    this.state = {
      
      user_id:'',
      posts: [],
      branch:[],
      codes:[],
      formData: {
        sapcode: '',
        firstname: '',
        middlename: '',
        lastname: '',
        email:'',
        

    },
    submitted: false,
    }
    //this.handleSubmit = this.handleSubmit.bind(this);
  }



  componentDidMount(){
    window.googleTranslateElementInit = this.googleTranslateElementInit
    const google = window.google;
const script = document.createElement("script");
script.src = "//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit";
script.async = true;
document.body.appendChild(script);  

    const answer_array = this.props.location.pathname.split('/');
    //alert(answer_array['3']);
    if(answer_array['3']){
      
      this.state.user_id = answer_array['3'];
      fetch(myConstClass.BASE_URL+'user/getRequestInfo/'+answer_array['3'])
  .then(response => response.json())
  .then(response =>{this.setState({formData: response})}).catch(err => console.log(err))
      
    }else{
      this.state.user_id = '';
    }

    
  if(!localStorage.getItem('session_id')){
    console.log('History:',this.props);      
    this.props.history.push('/');
  }

  }




  googleTranslateElementInit () {
    // / eslint-disable no-new /
    const google = window.google;
      new google.translate.TranslateElement({pageLanguage: 'en'}, 'google_translate_element_1');
    new window.google.translate.TranslateElement({pageLanguage: 'pt', layout: window.google.translate.TranslateElement.FloatPosition.TOP_LEFT}, 'google_translate_element_1')
  }
  handleHrReq(id) {
    // this.props.history.push('/hradmin/listing/0/'+id);
}

  render () { 
    const { formData, submitted,branch,codes } = this.state;
    const { posts} = this.state;
    
    // const file_link = `https://alpha.workzoneplus.com/backend/uploads/`+formData.personal_doc;
    const file_link = `https://beta.workzoneplus.com/backend/uploads/`+formData.personal_doc;
    return(
    <Container fluid>
      <Header><div  id="google_translate_element_1"></div><br/>
        <HeaderTitle>{(this.state.user_id !=='0' ) ? 'view' : 'Add' }</HeaderTitle>
  
        <Breadcrumb>
          <BreadcrumbItem>
            <Link to="/dashboard">Dashboard</Link>
          </BreadcrumbItem>
          <BreadcrumbItem>
            <Link to="/signup/listing">Signup Requests</Link>
          </BreadcrumbItem>
          <BreadcrumbItem active>{(this.state.user_id !=='0' ) ? 'View' : 'Add' }</BreadcrumbItem>
        </Breadcrumb>
      </Header>
  
      <Card>
        {/* <CardHeader>
          <CardTitle tag="h5">Availity Validation</CardTitle>
          <h6 className="card-subtitle text-muted">
            Form validation by availity-reactstrap-validation
          </h6>
        </CardHeader> */}
        <CardBody>
          <AvForm id="pform" onValidSubmit={this.handleValidSubmit}>
           
            {/* With AvGroup AvInput and AvFeedback to build your own */}
            <Row>
              <Col lg={6}>
            <AvGroup>
              <Label for="example">Name</Label>
              <AvInput name="name" disabled id="example" required value={formData ? formData.name:''}/>
              {/* <AvFeedback>Enter Title!</AvFeedback> */}
            </AvGroup>
            </Col>
            <Col lg={6}>
            <AvGroup>
              <Label for="example">Organization</Label>
              <AvInput name="organization" disabled id="example" required value={formData ? formData.organization:''}/>
              {/* <AvFeedback>Enter Weight</AvFeedback> */}
            </AvGroup>
            </Col>
            <Col lg={6}>
            <AvGroup>
              <Label for="example">Mobile No</Label>
              <AvInput name="mobile_no" disabled id="example" required value={formData ? formData.mobile_no:''}/>
              {/* <AvFeedback>Enter Weight</AvFeedback> */}
            </AvGroup>
            </Col>
            <Col lg={6}>
            <AvGroup>
              <Label for="example">Email</Label>
              <AvInput name="quantity" disabled id="example" required value={formData ? formData.email:''}/>
              {/* <AvFeedback>Enter Quantity!</AvFeedback> */}
            </AvGroup>
            </Col>
            <Col lg={6}>
            <AvGroup>
              <Label for="example">Position</Label>
              <AvInput name="position" disabled id="example" required value={formData ? formData.position:''}/>
              {/* <AvFeedback>Enter Quantity!</AvFeedback> */}
            </AvGroup>
            </Col>
            <Col lg={6}>
            <AvGroup>
              <Label for="example">Website</Label>
              <AvInput name="website" disabled id="example" required value={formData ? formData.website:''}/>
              {/* <AvFeedback>Enter Quantity!</AvFeedback> */}
            </AvGroup>
            </Col>
            <Col lg={6}>
            <AvGroup>
              <Label for="example">Reference</Label>
              <AvInput name="reference" disabled id="example" required value={formData ? formData.reference:''}/>
              {/* <AvFeedback>Enter Quantity!</AvFeedback> */}
            </AvGroup>
            </Col>
            <Col lg={6}>
            <AvGroup>
              <Label for="example">City</Label>
              <AvInput name="city" disabled id="example" required value={formData ? formData.city:''}/>
              {/* <AvFeedback>Enter Quantity!</AvFeedback> */}
            </AvGroup>
            </Col>
            <Col lg={6}>
            <AvGroup>
              <Label for="example">Country</Label>
              <AvInput name="country" disabled id="example" required value={formData ? formData.country:''}/>
              {/* <AvFeedback>Enter Quantity!</AvFeedback> */}
            </AvGroup>
            </Col>
            <Col lg={6}>
            <AvGroup>
              <Label for="example">Personal Document</Label>
              {/* <AvInput name="personal_doc" id="example" required value={formData ? formData.personal_doc:''}/> */}
              {/* <AvFeedback>Enter Quantity!</AvFeedback> */}
              <a href={file_link} target="_blank"><h5>{formData.personal_doc}</h5></a>
            </AvGroup>
            </Col>
            </Row>
            <Row>
             
            <Col lg={6}>
            </Col>
            </Row>
            <Row>
            </Row><br/>
           
  
            <FormGroup>
            <Link to="/signup/listing" style={{margin:"0rem 1.50rem 1.50rem 0rem",border: "#6f42c1 1px solid",color: "#6f42c1",padding: "0.10rem 0.90rem 0.30rem 0.90rem",textDecoration: 'none',borderRadius:'0.2rem'}}>Cancel</Link>
            {/* <button style={{marginTop:'15px'}}
                      type="button"
                      onClick={this.handleHrReq(this.state.user_id)}
                      className="btn btn-primary btn-sm"
                    >  Create HR Admin </button><br/> */}
                    
                 <Link to={'/hradmin/add/'+'hr'+this.state.user_id } className="btn btn-primary"> Create HR Admin</Link>
               </FormGroup>
          </AvForm>
        </CardBody>
      </Card>
    </Container>
  )
  }

}
 
export default Signup; 
