const jQuery = require("jquery");

jQuery.fn.vectorMap("addMap", "oceania_mill", {
  insets: [
    {
      width: 900,
      top: 0,
      height: 606.4292604642054,
      bbox: [
        { y: -2119119.6569834785, x: -7472412.761398178 },
        { y: 6796504.590523286, x: 5759240.699079444 }
      ],
      left: 0
    }
  ],
  paths: {
    GU: {
      path: "M240.87,42.61l-0.01,-0.59l0.19,-0.14l-0.18,0.73Z",
      name: "Guam"
    },
    PW: {
      path: "M164.06,87.32l0.02,-0.17l0.14,-0.24l-0.03,0.17l-0.13,0.24Z",
      name: "Palau"
    },
    KI: {
      path: "M679.59,130.26l0.02,-0.03l0.02,0.04l-0.04,-0.01Z",
      name: "Kiribati"
    },
    NC: {
      path:
        "M416.93,308.88l0.36,0.45l0.68,0.17l-0.06,0.61l-0.58,0.13l-0.49,-0.35l-0.29,-0.93l0.39,-0.08ZM411.15,303.46l0.49,0.13l-0.03,1.1l1.04,1.41l-0.11,0.35l-1.92,-1.24l0.92,-0.97l-0.39,-0.79ZM387.8,299.51l0.1,0.08l-0.08,-0.04l-0.02,-0.04ZM388.42,299.97l0.82,0.48l1.04,-0.13l3.92,3.03l1.69,0.74l1.34,1.25l0.46,1.08l1.66,1.52l4.92,2.99l2.91,2.49l1.84,1.04l0.25,1.28l-1.16,0.29l-2.23,-0.94l-2.05,-1.21l-0.77,-1.13l-1.95,-0.76l-0.68,-0.65l-3.72,-1.95l-2.37,-1.87l-3.56,-3.62l-2.07,-2.66l-0.28,-1.29Z",
      name: "New Caledonia"
    },
    NU: {
      path: "M585.07,289.99l0.09,0.19l-0.28,0.16l0.14,-0.33l0.05,-0.02Z",
      name: "Niue"
    },
    NZ: {
      path:
        "M534.0,498.67l0.36,-0.21l0.11,0.44l-0.47,-0.23ZM534.78,500.22l0.77,0.62l-1.2,0.49l-0.15,-0.45l0.58,-0.66ZM456.17,419.08l-1.68,-1.97l-0.75,-0.96l1.06,-0.1l-0.2,0.67l1.56,2.36ZM456.68,419.85l0.23,0.29l0.07,0.25l-0.31,-0.53ZM457.03,420.47l0.58,0.21l0.67,-0.58l2.79,1.38l0.58,-0.3l1.64,0.84l0.08,0.94l0.47,0.51l0.77,-0.01l0.46,-0.36l1.44,2.46l-0.19,0.87l0.24,0.45l-0.71,-0.11l-0.42,0.67l3.03,4.43l-0.3,1.67l0.39,0.8l-0.65,2.1l0.33,0.36l0.55,0.1l0.25,0.12l0.26,0.27l0.74,-0.29l2.34,1.04l0.32,1.34l0.57,0.62l1.33,-0.05l0.51,-0.81l-0.73,-4.4l0.88,1.11l0.65,0.11l0.53,0.95l1.09,4.81l0.62,0.67l-0.26,0.77l0.68,0.6l1.46,0.35l3.68,1.86l3.95,0.93l1.46,-0.34l0.89,-0.57l1.35,-1.73l1.94,-1.2l1.76,0.09l1.67,0.89l-1.01,2.1l-0.91,5.05l-2.25,1.62l-0.51,2.71l0.29,1.27l-0.75,-0.82l-2.11,-0.34l-1.82,0.4l-1.83,1.05l-0.96,1.34l-0.2,1.33l0.27,1.17l0.92,0.6l-1.84,3.95l-3.46,4.58l-3.0,4.84l-4.81,3.42l-0.34,-0.17l-0.64,-1.52l-0.85,-0.24l-1.06,0.28l0.13,-1.04l-0.38,-0.71l-0.59,0.01l-0.34,0.74l-0.57,0.11l2.75,-3.69l1.16,-2.15l0.7,-3.0l-0.78,-1.83l-1.27,-1.61l-1.48,-0.82l-1.86,-0.43l-1.67,-1.52l-3.13,-1.19l-0.8,-0.64l-0.28,-0.74l0.44,-1.22l1.64,-0.91l2.56,-0.65l1.64,-1.73l0.9,-4.94l0.95,-1.82l-0.24,-1.18l0.67,-0.5l0.2,-0.58l-1.32,-2.57l0.14,-1.16l-0.75,-0.92l0.51,-0.24l0.33,-0.63l0.78,-0.17l0.26,-0.67l-1.11,-1.23l-1.67,0.22l-0.64,-0.25l-1.09,-2.38l0.54,-0.07l0.47,-1.07l-0.13,-0.71l-0.63,-0.64l0.32,-0.68l-0.15,-0.57l-0.85,-0.69l-0.81,0.36l-1.0,-0.67l-0.86,-1.73l-0.43,-0.24l-0.34,0.35l-0.0,0.82l-2.91,-3.94l1.5,-1.78l-0.31,-0.53l-0.58,-0.02l-1.4,1.37l-0.4,-0.98l-1.02,-0.98l0.42,-0.68l-0.04,-1.11ZM463.41,431.7l0.14,0.17l0.06,0.19l-0.06,-0.05l-0.14,-0.3ZM473.83,433.91l-0.09,-0.09l0.01,-0.04l0.05,0.08l0.02,0.05ZM473.39,430.83l0.04,-0.47l0.56,0.82l-0.04,-0.04l-0.56,-0.32ZM406.28,517.99l3.24,-0.57l0.56,-0.45l-0.24,-0.69l-1.17,-0.17l1.23,-0.78l0.19,-0.49l-0.45,-0.26l-1.43,0.13l0.15,-0.49l0.83,-0.01l0.28,-0.63l1.38,0.63l0.44,-0.13l-0.23,-0.9l0.87,-0.42l-0.21,-0.42l-1.32,-0.54l-0.02,-0.48l0.38,-0.34l1.08,0.15l0.16,-0.71l-0.45,-0.48l1.16,-0.93l0.64,0.96l0.37,-0.31l0.02,-1.52l2.05,-1.51l1.08,0.55l0.21,-0.42l-0.38,-1.33l3.71,-3.73l1.92,-0.91l1.22,0.16l1.86,-1.13l0.75,0.38l0.51,-0.52l-0.16,-0.82l2.48,-1.34l2.28,-0.78l0.34,-0.7l0.51,-0.26l-0.06,-0.35l2.54,-2.19l1.15,0.17l0.15,-0.47l-0.3,-0.58l0.42,-0.18l0.95,0.42l0.52,-0.13l-0.43,-0.81l0.36,-0.15l0.84,0.54l0.24,-1.09l1.31,-1.43l0.21,1.19l0.65,-0.3l0.05,-1.7l1.1,-1.61l0.68,-0.24l0.32,-0.57l-0.35,-0.49l1.65,-5.17l1.76,-0.59l1.7,-1.7l1.18,-3.2l0.35,-2.27l0.93,-1.57l1.42,-1.17l1.31,-0.91l0.05,1.65l0.47,0.66l1.58,0.66l0.53,2.86l0.7,1.09l1.15,-0.05l4.31,-2.8l0.11,0.54l-0.71,1.61l0.02,0.47l0.46,0.12l0.95,-0.46l0.96,-1.91l0.78,-0.14l0.31,0.23l-1.71,1.71l1.15,0.38l-0.89,1.09l0.03,0.71l0.52,0.71l-0.43,0.72l0.42,0.6l0.69,-0.01l0.28,0.32l-0.18,0.4l-2.57,2.75l-0.44,1.35l-2.23,2.26l-2.43,4.17l-2.39,1.27l-1.31,1.23l-0.61,0.11l-0.31,0.68l0.71,0.52l-1.35,0.68l-0.08,0.46l0.42,0.22l1.19,-0.12l0.75,1.55l1.92,0.5l0.03,0.99l-0.93,0.23l-1.38,-0.72l-0.98,0.11l0.01,-0.4l-0.89,-0.49l-0.81,0.3l-0.62,0.96l-1.84,-1.44l-0.47,0.01l-0.01,0.81l0.81,1.17l-3.5,1.79l-1.66,0.19l-0.67,1.11l-1.15,0.41l0.49,0.53l-0.81,4.15l-0.3,1.02l-0.81,-0.01l-0.32,0.64l0.82,0.76l-1.29,1.64l-0.42,1.57l-1.45,3.04l0.68,1.41l-2.5,0.63l-0.79,0.55l-1.17,1.63l-2.05,1.67l-1.65,1.96l-2.48,0.62l-1.76,0.09l-2.45,-0.6l-1.6,0.39l-1.29,-0.07l-0.22,-1.23l-1.12,-0.97l-2.65,-0.03l-1.13,-1.52l-1.23,-0.52l-0.58,0.04l-0.93,0.82l-1.95,0.07l-2.47,-0.39l1.36,-1.7l0.03,-0.51l-0.5,-0.12l-0.89,0.52l-0.06,-0.93l-0.63,-0.19l-1.14,0.59l0.02,-0.63ZM464.16,475.77l0.52,-0.33l-0.28,0.26l-0.25,0.06ZM461.7,471.81l0.05,-0.2l0.28,-0.24l-0.17,0.35l-0.16,0.08ZM425.9,583.44l0.01,-0.0l0.04,0.01l-0.02,0.01l-0.03,-0.02ZM414.34,530.94l1.81,-2.66l-0.07,-1.86l0.78,-0.03l0.94,1.05l-0.52,0.4l0.02,0.43l1.57,1.04l-1.43,0.31l-0.89,0.58l-0.91,-0.01l-1.28,0.74ZM407.01,516.29l0.33,-0.1l0.09,0.24l-0.23,-0.03l-0.19,-0.11ZM402.53,565.46l0.62,-0.57l0.23,-1.11l0.23,-0.02l-0.42,1.57l0.35,0.71l-1.02,-0.58Z",
      name: "New Zealand"
    },
    AU: {
      path:
        "M3.12,347.94l0.52,-0.43l1.06,2.65l-1.15,-1.41l-0.44,-0.81ZM4.9,350.4l1.59,0.34l0.85,-0.84l0.22,-1.59l-1.05,-1.13l0.68,-0.45l0.33,1.19l1.2,1.17l1.13,-0.44l0.47,-0.75l-0.08,-3.75l-4.08,-7.01l-0.76,-2.25l-1.13,-2.04l0.03,-2.27l0.5,-2.04l2.04,-3.72l0.29,-4.05l-0.82,-2.23l2.0,-5.31l0.64,-0.5l-0.35,2.13l0.52,1.26l-0.15,1.15l0.56,0.42l1.19,-0.44l0.74,-0.79l2.47,-4.07l5.57,-2.58l4.25,-3.68l5.17,-2.92l3.08,-0.08l1.06,0.52l1.15,0.09l2.17,-0.64l3.84,-2.09l4.16,-0.89l2.71,-2.08l3.47,0.33l1.53,-0.64l3.25,-0.39l6.19,-2.46l2.67,-2.33l1.21,-1.73l2.47,-4.79l1.32,-0.68l2.69,-2.42l-0.03,-0.98l-0.83,-0.51l-0.64,-3.04l0.08,-1.65l0.7,-1.28l3.49,-2.73l1.31,-2.45l1.18,2.99l1.88,3.44l1.4,1.82l0.67,-0.22l0.33,-2.33l-0.14,-1.24l0.99,0.77l0.53,0.0l0.63,-2.09l-2.7,-2.97l0.82,-0.71l-0.08,-1.51l1.13,1.36l0.46,0.16l1.29,-0.88l1.94,0.95l3.47,0.1l0.44,-0.57l-0.32,-0.42l-2.45,-0.43l0.07,-0.85l0.88,0.03l0.38,-0.37l0.54,-1.93l-0.0,-0.5l-0.56,-0.37l-0.84,0.81l-0.61,-0.92l0.34,-1.61l0.89,-0.02l1.08,-1.51l1.76,1.22l0.87,-0.06l0.29,-1.43l-0.48,-0.36l-0.91,0.03l-0.23,-0.66l1.2,-0.7l2.06,0.67l0.44,-0.18l0.27,-0.97l-1.07,-0.85l-0.47,-1.05l0.73,-1.22l1.06,-0.18l1.09,-0.66l0.65,0.5l0.52,-0.54l0.45,1.05l0.84,0.0l1.04,-1.16l-0.03,-0.89l0.71,-1.98l-0.35,-0.79l0.73,1.32l0.57,0.13l0.83,-0.97l1.02,0.91l0.5,0.04l1.7,-1.68l0.01,-1.23l0.61,-0.21l3.96,2.12l1.59,1.24l1.65,2.26l2.14,1.69l-0.83,2.64l-0.08,1.87l0.55,0.39l0.68,-0.63l0.28,0.3l0.69,-0.24l-0.61,-1.85l1.75,-1.57l0.9,-0.26l3.45,0.81l0.63,0.62l0.06,0.84l0.41,0.58l0.69,-0.16l0.15,-1.89l1.06,0.36l1.32,1.58l0.63,-0.2l0.12,-0.41l-0.19,-1.55l1.38,-0.16l0.16,-0.71l-1.53,-1.02l0.55,-0.78l-2.34,-1.36l0.47,-1.07l1.95,-1.97l0.89,-2.93l2.11,-0.87l1.1,-1.25l-0.01,-0.48l-0.84,-1.08l0.18,-1.06l1.15,-0.69l0.57,-1.37l1.48,-0.23l0.24,-1.76l1.27,1.03l0.53,-0.06l0.33,-0.61l-0.14,-0.81l1.1,-0.46l0.01,-0.83l1.1,-0.08l0.44,-0.35l0.23,0.52l0.96,0.59l2.18,0.01l1.21,-0.33l1.28,0.34l1.54,-0.67l0.84,0.62l0.72,-0.13l0.54,-0.97l1.43,-0.06l0.22,-0.66l-0.51,-0.55l0.17,-3.13l-1.71,-1.29l-2.87,-0.07l-1.51,-1.18l0.5,-0.31l1.47,0.96l0.63,-0.29l0.23,-0.48l0.26,0.07l1.6,1.04l0.92,1.02l0.5,0.08l1.22,-0.8l0.53,0.08l1.8,2.31l1.25,0.17l1.46,0.68l2.69,0.11l2.4,1.28l1.57,0.42l1.09,0.03l1.23,-0.5l2.28,1.54l1.71,0.15l4.14,-2.33l0.11,0.19l-1.09,0.98l0.04,1.05l0.67,0.32l1.31,-0.64l1.09,2.04l1.76,-0.13l0.54,-1.3l-0.44,-1.04l1.38,-1.13l0.55,1.27l0.83,0.71l1.31,0.14l0.2,0.43l-3.01,3.27l-0.1,0.75l0.48,1.02l-0.82,1.38l-1.19,-0.65l-2.8,1.29l-0.21,0.36l0.01,2.45l0.44,1.46l-0.74,2.43l-3.6,4.67l0.41,1.78l5.69,3.73l0.76,1.36l2.24,1.07l0.65,-0.14l-0.01,0.86l0.81,0.69l1.78,-0.03l2.18,1.4l2.99,1.27l1.56,1.85l2.58,1.93l2.07,0.6l0.95,-0.07l2.76,0.9l1.92,3.37l1.39,0.39l4.48,2.5l1.62,0.05l2.39,-0.67l2.45,-1.66l1.16,-3.27l1.88,-2.82l0.59,-1.5l0.92,-3.07l-0.11,-1.4l0.43,-2.24l1.33,-4.39l-0.76,-4.49l0.5,-2.62l-0.84,-1.71l-0.05,-0.84l1.29,-4.06l-0.2,-2.4l1.04,-1.03l0.66,0.14l0.59,-0.29l0.07,-0.49l-0.66,-1.54l-1.22,-0.66l0.06,-0.76l1.06,-2.33l0.38,0.28l0.64,-0.29l-0.06,-1.22l1.39,-4.7l0.21,-2.33l1.11,-0.48l0.94,-1.23l0.3,0.0l-0.07,1.19l1.23,0.99l0.79,2.11l0.26,3.9l1.04,1.03l1.21,0.23l-0.49,1.33l0.04,1.13l1.16,0.94l1.04,1.72l1.4,6.11l-0.26,2.37l1.57,4.67l0.72,0.67l1.4,0.47l1.89,-1.23l1.68,-0.45l1.22,1.88l4.65,3.33l-0.24,1.11l0.3,1.69l-0.14,1.29l1.39,4.45l-0.2,2.82l2.53,3.74l1.09,0.41l-0.02,1.01l1.65,4.27l-0.7,5.0l1.53,2.06l0.7,0.34l-0.22,1.98l0.71,1.31l1.68,1.41l1.9,0.79l1.28,0.17l1.14,1.09l2.1,-0.06l1.07,1.76l1.18,1.16l0.89,0.27l0.6,0.62l1.22,0.23l2.05,1.42l1.78,0.47l1.14,1.08l0.61,0.89l-0.91,0.1l-0.31,1.25l0.86,1.3l3.06,2.98l0.92,2.69l0.94,0.9l0.54,3.46l0.54,1.86l0.85,1.52l0.44,0.21l0.75,-0.25l0.94,1.02l0.56,-0.0l0.34,-0.63l-0.45,-1.59l0.39,-0.73l1.1,1.49l2.4,1.56l0.55,0.04l0.36,-0.48l-0.09,-0.86l0.7,1.22l0.15,4.76l0.58,2.47l2.43,2.67l2.57,1.8l1.56,0.28l0.93,0.59l2.19,3.73l2.47,1.67l0.33,1.24l1.17,1.95l1.08,0.67l0.82,1.11l0.09,2.11l0.86,1.54l0.92,0.63l-0.57,2.68l0.58,5.46l-0.32,1.88l2.04,4.7l0.55,2.35l0.86,1.48l-0.05,2.29l0.36,1.21l-0.08,1.31l-1.92,3.57l-0.59,5.03l-1.84,5.67l0.13,2.88l-0.77,4.3l-1.16,2.85l-1.68,2.13l-0.7,3.33l-2.59,2.21l0.13,0.44l-2.52,1.26l-2.53,3.86l-0.36,1.31l-0.93,0.47l-0.27,3.16l-1.04,0.48l0.32,0.72l-1.61,1.81l-0.74,1.82l-0.71,3.43l0.14,0.76l-0.75,0.47l0.03,0.92l-1.01,0.55l-2.85,5.41l-1.0,6.19l-0.78,2.59l0.18,3.67l-0.31,2.02l-0.87,0.21l-2.38,1.89l-9.12,0.5l-3.09,0.96l-3.7,2.54l-4.01,3.85l-4.82,0.58l-0.25,0.85l1.0,1.25l0.59,0.04l0.35,-0.33l0.09,1.47l-0.28,0.35l-1.63,-2.39l-0.67,-0.28l-0.99,0.43l-0.94,-1.74l-1.61,-0.29l-1.22,-0.83l0.99,-1.18l-0.82,-1.62l-1.54,-0.05l-0.99,1.39l-1.44,0.85l-0.72,-0.5l0.61,-0.12l0.82,-0.75l0.86,-1.62l-0.61,-1.13l-1.27,-1.04l-4.17,2.07l0.09,0.73l1.49,0.24l-3.81,1.9l-2.24,2.12l-1.83,0.97l-2.19,-0.64l-1.01,-0.79l-1.91,-0.63l-3.03,-1.75l-2.03,0.09l-1.87,-0.95l-1.67,-0.15l-1.18,1.01l-0.92,-0.15l-1.52,-1.61l-1.64,-0.91l-2.95,-0.46l-1.64,-1.06l-1.36,-2.23l-3.17,-3.37l-0.3,-1.39l0.9,-3.46l-1.02,-2.77l-2.03,-3.18l-3.34,-2.93l0.68,-0.54l0.92,0.67l0.5,-0.38l0.23,-1.42l-0.36,-0.85l-1.18,-0.37l-2.44,1.6l-1.03,0.14l-1.54,0.77l-1.87,-0.16l1.43,-2.04l0.84,-2.59l-0.14,-2.39l-3.1,-5.26l-0.69,0.02l-1.27,2.41l-0.4,2.44l-1.27,3.28l-1.59,-0.1l-2.37,0.89l-1.35,0.13l0.73,-2.06l2.6,-0.05l0.35,-0.26l0.79,-2.76l-0.25,-1.93l0.25,-1.77l1.14,-2.47l2.18,-2.64l-0.57,-2.93l1.03,-1.21l-0.63,-2.82l-1.03,-1.7l-0.44,-0.14l-0.28,0.38l0.05,1.97l-2.54,2.99l-1.56,3.69l-4.43,2.18l-1.7,1.27l-4.02,5.31l-0.05,0.91l0.65,1.55l-0.82,-0.72l-1.29,0.41l-1.9,-1.96l0.45,-0.11l0.26,-0.59l-1.75,-5.29l-2.51,-2.9l-0.81,-2.61l-1.47,-1.24l-2.3,-0.26l-0.83,-1.36l-0.43,-1.51l0.85,-0.32l0.18,-0.76l-0.33,-1.24l-2.24,-1.12l-1.04,-1.15l-1.12,-0.64l-3.42,-0.21l-3.53,-1.91l-3.99,0.44l-3.71,-2.58l-2.56,-1.27l-1.92,-0.45l-2.85,0.9l-4.94,-0.2l-9.01,1.04l-6.7,3.07l-5.64,1.65l-3.99,0.38l-4.84,-0.45l-1.78,0.34l-2.78,1.81l-2.28,0.91l-3.8,2.24l-3.92,1.13l-1.08,1.16l-1.92,3.89l-1.59,1.96l-0.92,0.57l-1.18,-0.03l-0.97,0.57l-0.85,-0.6l-1.1,-0.22l-5.89,0.88l-0.8,-0.95l-5.07,-0.41l-4.52,0.38l-2.98,0.76l-1.58,-0.22l-2.69,0.33l-1.84,1.15l-1.45,2.3l-1.35,0.66l-2.82,0.28l-5.68,4.28l-4.04,0.92l-7.93,-0.92l-3.9,-1.61l-1.9,-2.22l-1.3,-0.92l-2.23,-1.07l-1.27,0.2l-0.55,-0.45l-0.26,-1.61l0.11,-3.76l1.07,0.75l1.58,-0.11l1.3,-1.06l1.29,-2.9l-0.45,-4.53l0.66,-0.86l0.22,-5.83l-0.35,-1.75l-3.94,-7.4l-0.72,-1.99l-0.81,-4.24l-0.07,-5.04l-0.79,-2.48l-1.75,-2.31l-0.72,-2.74l-2.79,-3.76l-0.47,-4.23l-0.59,-1.78l-2.41,-4.07l-1.52,-1.87ZM5.49,346.12l-1.4,-2.96l0.13,-0.37l1.47,1.56l-0.2,1.77ZM307.15,358.08l0.01,-0.18l0.17,-0.41l-0.17,0.59ZM304.06,342.63l-0.11,-0.67l0.63,-1.96l-0.13,-0.79l1.06,-0.95l0.38,-0.95l0.09,0.6l-1.92,4.72ZM305.51,336.0l-0.11,-0.12l0.09,-0.06l0.01,0.18ZM289.28,325.66l0.66,0.31l0.41,1.19l-0.1,-0.07l-0.97,-1.43ZM266.67,467.87l1.59,-0.39l0.64,0.6l-0.17,0.16l-0.57,-0.46l-1.49,0.09ZM243.31,471.7l1.77,-0.15l4.12,2.28l3.94,1.28l1.95,-0.19l1.08,-0.5l1.13,0.69l0.22,-1.1l0.75,-0.44l2.34,-0.32l1.38,0.29l1.11,-1.28l1.78,0.23l0.91,-0.83l1.42,0.59l0.45,0.64l0.17,8.76l-1.01,0.49l-0.84,1.56l-0.47,2.5l-0.64,1.27l-0.07,2.29l0.48,2.95l-0.95,0.22l-0.68,-1.2l0.97,-0.2l-0.08,-1.09l-1.83,-0.81l-0.68,0.4l-0.09,1.11l-0.29,-0.96l-0.83,-0.94l-0.45,-0.1l-0.25,0.4l0.34,1.49l-0.6,0.9l-0.12,1.26l-1.28,-0.65l-0.61,0.22l-0.09,0.72l0.52,0.57l-1.23,2.68l-0.91,-0.12l-1.34,-0.88l-3.5,0.25l-0.25,-0.76l1.35,-0.11l0.38,-0.54l-0.14,-0.36l-0.42,-0.34l-2.38,-0.16l-1.79,-2.52l-0.91,-0.65l-1.62,-3.41l-0.37,-1.83l1.49,1.9l0.83,-1.19l-0.06,-0.58l-1.24,-1.29l-0.16,-0.56l-0.55,-0.23l-0.23,-1.11l-2.41,-3.36l-1.08,-2.17l-0.9,-3.6l0.5,-2.13l1.97,0.74ZM264.9,463.05l0.55,-0.7l1.44,1.63l0.8,0.35l-0.22,0.56l0.25,0.75l-1.02,0.51l-1.23,-1.81l-0.17,-1.04l-0.38,-0.24ZM259.93,495.5l0.38,-0.53l0.12,-0.34l-0.07,0.94l-0.43,-0.07ZM252.24,284.34l0.26,-0.08l0.33,0.97l-0.33,-0.6l-0.26,-0.29ZM245.66,449.75l0.13,-0.01l-0.11,0.06l-0.02,-0.05ZM235.03,464.86l-0.28,-1.49l0.15,-1.37l0.61,-1.0l0.36,0.27l0.32,2.59l-1.15,1.0ZM221.75,225.27l0.17,0.16l-0.1,0.07l-0.03,-0.02l-0.04,-0.22ZM199.24,271.61l0.83,-1.24l1.97,-0.48l0.13,0.16l-2.07,1.39l-0.86,0.17ZM186.63,426.84l0.35,0.43l1.81,0.2l0.78,-0.28l0.92,0.61l-1.74,-0.21l-1.25,0.26l-0.85,1.2l-0.66,0.25l-1.8,-0.72l-0.71,0.45l-2.69,-0.01l-1.3,-0.93l0.49,-0.77l5.11,-1.31l1.66,0.19l-0.12,0.63ZM178.36,252.29l0.17,-2.22l1.29,-1.17l0.24,0.75l0.61,0.43l-0.47,1.73l1.01,0.85l-2.87,-0.38ZM176.38,249.17l0.08,-0.08l0.09,-0.12l0.03,0.15l-0.2,0.04ZM148.87,228.94l0.1,0.2l-0.04,0.14l-0.12,-0.23l0.05,-0.11ZM132.92,230.01l0.94,0.93l1.29,0.21l1.25,-0.54l0.89,0.15l1.79,-0.92l1.49,1.32l-1.58,1.79l-2.31,1.48l-3.0,-2.14l-0.61,-1.2l-0.15,-1.09ZM130.25,233.73l0.95,-0.55l-0.08,-1.67l0.68,-0.72l0.78,2.33l1.01,0.62l-1.81,-0.41l-1.52,0.39ZM0.69,343.22l0.25,0.69l-0.14,-0.24l-0.11,-0.45Z",
      name: "Australia"
    },
    PG: {
      path:
        "M317.31,186.15l1.37,0.38l0.59,0.49l0.78,1.57l1.32,1.12l0.8,1.37l1.32,0.59l1.29,1.13l0.73,1.28l0.13,1.04l-1.43,0.68l-0.6,-0.04l-1.86,-0.92l-0.88,-1.24l0.16,-0.94l-0.24,-0.79l-1.55,-0.91l-1.82,-2.0l-0.34,-1.24l0.24,-1.57ZM316.23,184.69l-0.36,-1.75l0.21,-0.24l0.31,1.07l-0.16,0.92ZM306.38,231.17l1.21,0.64l1.04,0.34l-1.74,-0.38l-0.52,-0.59ZM287.63,164.8l0.1,-0.36l0.53,0.36l-0.63,-0.0ZM291.46,166.57l1.34,0.67l1.75,1.32l1.64,0.57l0.93,1.02l-1.67,-0.58l-3.99,-3.0ZM299.57,172.25l3.99,3.29l0.72,0.98l-0.75,2.84l-0.56,0.78l-1.26,-1.99l-0.13,-2.87l-2.0,-3.03ZM301.3,212.7l0.78,-0.03l1.13,0.78l-0.49,0.34l-0.8,-0.34l-0.63,-0.75ZM281.23,184.76l0.26,0.8l0.85,0.87l0.88,0.09l1.63,-0.56l0.93,0.45l0.82,-0.08l1.38,-0.51l0.57,-0.32l1.36,-2.3l1.34,-1.08l1.86,-0.18l0.95,-0.74l-0.05,-1.94l-0.86,-2.27l0.13,-0.59l1.32,0.1l1.16,0.75l1.25,-0.66l1.72,0.78l-0.21,0.9l0.27,1.65l-0.31,0.59l-0.64,0.92l-1.6,0.28l-0.57,0.78l0.14,0.98l0.96,1.31l-0.32,0.49l-1.36,0.69l-2.91,0.05l-0.71,1.48l-1.38,1.24l-3.11,1.11l-2.56,1.46l-5.93,0.18l-2.0,-1.59l-2.1,0.31l-2.9,-1.9l-2.34,-0.76l-0.34,-0.51l0.04,-0.64l0.37,-0.31l0.91,0.23l3.25,-0.17l2.72,0.75l2.15,-0.5l1.47,0.05l1.2,-0.63l0.31,-1.04ZM281.64,182.69l0.03,-0.1l0.06,-0.03l0.02,0.02l-0.1,0.11ZM288.07,219.52l0.46,0.33l-0.02,0.09l-0.11,-0.17l-0.33,-0.26ZM288.62,220.3l0.88,0.4l0.83,-0.66l-0.26,0.96l-1.44,-0.45l-0.02,-0.25ZM284.67,215.58l1.19,0.54l0.89,-0.08l0.52,0.55l0.06,0.55l-2.19,-0.22l0.04,-0.55l-0.5,-0.79ZM213.01,164.32l1.09,0.12l4.9,2.29l5.42,2.07l2.74,0.89l4.48,0.81l4.24,2.84l3.1,0.15l1.01,1.19l1.68,0.86l1.83,1.86l1.97,0.37l3.1,3.14l-0.03,4.53l0.96,0.58l4.09,1.08l4.82,2.31l2.65,0.26l1.23,0.7l1.73,1.94l0.26,2.21l-3.31,0.37l-1.76,-0.16l-1.51,0.92l-0.11,1.15l1.81,3.58l4.09,3.84l3.0,1.71l0.85,3.28l1.58,1.19l1.19,2.87l1.75,0.32l2.88,-0.48l0.28,0.73l-0.45,1.73l0.52,0.96l1.82,0.85l3.58,0.5l-1.41,0.41l-0.27,0.39l0.11,0.73l0.81,1.06l3.91,1.51l1.36,0.14l0.3,0.12l-1.18,-0.04l-0.3,0.81l1.51,1.15l-0.81,0.48l-1.06,0.11l-2.05,-0.52l-0.55,-0.72l-1.65,-1.07l-6.19,-0.75l-2.14,-0.75l-1.75,0.25l-1.16,-0.48l-3.73,-0.44l-1.44,-1.08l-1.16,-1.86l-2.93,-2.16l-0.59,-0.91l0.13,-1.64l-0.97,0.13l-1.46,-0.88l-3.39,-5.37l-1.22,-1.38l-2.44,-1.02l-2.0,-0.18l-3.71,-0.96l-1.01,-1.32l-2.54,-0.48l-0.73,0.27l-0.27,0.55l-1.79,0.62l-1.71,-0.58l-1.87,-1.63l-0.51,0.11l0.03,0.52l0.62,0.64l1.2,2.37l-0.43,0.64l-2.31,-0.17l-0.13,0.62l0.5,0.98l-3.46,0.73l-2.94,-0.29l-1.39,0.37l-1.32,-1.17l-1.15,0.23l-0.27,0.44l0.39,0.34l0.69,0.01l1.12,1.24l2.58,-0.12l2.26,0.94l1.87,2.04l-0.04,1.05l-5.2,2.66l-3.01,-1.17l-4.64,0.31l-1.74,-0.46l-1.9,0.52l-0.9,-0.59l-0.01,-16.66l-0.85,-1.35l0.84,-2.91l-0.01,-27.96ZM281.58,162.9l1.08,-0.28l1.29,0.55l0.03,0.76l-1.54,-0.0l-0.85,-1.03ZM283.27,215.97l-1.0,-0.85l0.34,-0.57l0.5,0.26l0.16,1.16ZM278.62,155.65l-0.66,-0.55l0.06,-0.28l0.55,0.39l0.04,0.43ZM264.59,186.19l1.37,0.79l-0.08,0.81l-0.73,-0.38l-0.56,-0.73l0.01,-0.49ZM255.56,160.21l0.22,-0.71l1.45,-0.19l3.04,0.38l-0.56,0.54l-4.15,-0.02ZM259.41,184.95l-0.68,-0.65l0.49,-0.31l0.23,0.19l-0.04,0.78ZM250.53,179.67l-0.3,-0.16l0.37,-0.5l0.09,0.28l-0.15,0.38Z",
      name: "Papua New Guinea"
    },
    SB: {
      path:
        "M401.2,226.2l0.44,-0.5l0.72,-0.08l0.27,0.05l-0.74,0.06l-0.7,0.48ZM366.91,222.26l0.24,-0.14l0.84,0.36l-0.52,-0.17l-0.56,-0.04ZM368.23,222.63l2.3,1.29l2.05,0.15l1.1,1.91l-2.39,-0.37l-2.49,-1.35l-0.58,-1.62ZM367.84,217.48l0.01,-0.37l0.01,-0.13l0.24,0.52l-0.26,-0.02ZM361.82,207.84l0.44,-0.16l1.63,1.97l-0.3,0.51l0.01,1.05l1.59,1.22l0.69,1.68l0.08,1.03l-2.27,-1.71l-1.47,-3.77l0.27,-0.91l-0.67,-0.9ZM354.72,214.98l1.57,1.16l3.02,-0.01l1.88,1.18l1.3,1.62l-0.83,0.27l-2.47,-0.81l-3.42,-0.21l-1.5,-1.73l-0.09,-1.16l0.54,-0.3ZM360.03,233.55l0.05,0.04l-0.05,-0.03l-0.01,-0.01ZM346.24,202.07l0.73,0.16l2.81,2.24l2.45,0.96l2.8,2.04l-0.16,0.49l-0.67,-0.62l-5.23,-2.49l-2.51,-2.06l-0.22,-0.72ZM350.09,212.96l0.09,-0.06l0.14,0.09l-0.14,-0.03l-0.09,-0.01ZM341.2,209.54l0.67,-0.31l0.12,0.68l-0.63,0.23l-0.17,-0.61ZM339.58,207.08l0.82,1.76l-1.56,-0.79l-0.5,-1.51l-1.69,0.03l-0.56,0.29l1.65,-1.83l0.45,0.17l0.45,1.56l0.94,0.31ZM330.29,194.75l3.73,2.02l0.42,0.38l0.41,1.25l1.22,1.1l-1.12,-0.16l-1.38,-1.01l-1.54,-2.01l-1.74,-1.59ZM337.16,200.01l0.15,0.02l-0.03,0.02l-0.13,-0.04ZM336.24,209.27l-0.13,-0.17l0.54,-0.43l-0.06,0.17l-0.36,0.43ZM335.04,205.4l-0.51,-0.03l-0.43,-0.53l0.3,-0.6l0.65,0.34l-0.01,0.82ZM331.51,203.67l-0.81,-1.21l0.1,-0.34l1.25,0.9l-0.54,0.65ZM324.56,197.56l0.23,0.13l-0.29,0.05l0.06,-0.18Z",
      name: "Solomon Is."
    },
    PF: {
      path:
        "M818.2,218.52l0.51,-0.27l0.21,0.07l-0.66,0.22l-0.06,-0.02ZM809.81,211.26l0.74,0.09l-0.0,0.04l-0.63,0.19l-0.11,-0.33ZM740.27,279.5l-1.27,0.03l-0.3,-0.86l1.3,-0.09l0.27,0.91ZM741.11,280.1l0.34,0.11l0.08,0.22l-0.31,-0.13l-0.11,-0.2Z",
      name: "Fr. Polynesia"
    },
    FJ: {
      path:
        "M508.66,272.92l-0.0,-0.25l0.48,-0.39l-0.19,0.44l-0.29,0.21ZM497.43,272.16l0.3,-0.39l1.49,-0.09l1.33,-1.19l2.96,-0.78l1.51,-1.03l1.76,-0.2l-0.73,1.08l-1.04,0.74l-0.42,0.85l-0.01,1.03l-0.66,0.07l-0.66,-0.67l-1.06,-0.06l-1.33,0.86l-0.38,0.62l-0.94,-0.03l-0.92,0.55l-0.61,-1.13l-0.59,-0.21ZM506.04,271.76l0.18,-0.16l0.91,-0.62l-0.06,0.73l-1.03,0.05ZM494.84,277.19l0.18,0.54l2.2,1.7l-0.12,0.68l0.59,2.25l-2.1,0.26l-1.39,0.9l-1.42,0.11l-4.48,-1.33l-0.39,-1.1l1.18,-1.05l-0.08,-0.9l0.62,-0.57l2.18,-1.09l0.98,0.03l1.79,-0.6l0.27,0.17Z",
      name: "Fiji"
    },
    FM: {
      path: "M343.07,91.63l0.52,0.12l-0.04,0.44l-0.24,-0.01l-0.23,-0.55Z",
      name: "Micronesia"
    },
    WS: {
      path:
        "M569.03,249.95l0.88,-0.15l1.69,0.49l0.54,0.55l-2.46,-0.35l-0.65,-0.54ZM563.84,247.6l2.37,-0.43l0.64,0.55l0.25,0.72l-0.18,0.45l-1.9,0.02l-1.19,-1.3Z",
      name: "Samoa"
    },
    VU: {
      path:
        "M427.15,292.8l0.11,0.66l0.88,0.72l-0.11,0.23l-1.03,-0.95l0.15,-0.66ZM426.24,288.06l-0.02,0.44l0.75,0.77l-1.67,-0.73l0.05,-1.24l0.36,-0.08l0.52,0.83ZM419.3,279.22l0.36,-0.42l0.88,-0.01l0.69,0.96l-0.13,0.23l-1.13,-0.03l-0.17,-0.53l-0.5,-0.21ZM418.76,271.53l0.32,0.34l0.39,0.28l-0.55,0.09l-0.16,-0.71ZM417.42,268.27l1.12,-0.64l0.52,1.0l-1.39,-0.19l-0.26,-0.18ZM415.67,261.93l0.56,-0.52l0.37,-0.06l-0.54,0.6l-0.39,-0.01ZM411.57,267.12l-0.21,-0.24l0.28,-1.05l0.37,0.19l0.41,0.98l-0.85,0.12ZM412.83,267.52l2.5,1.78l0.24,0.51l-1.11,0.03l-0.96,0.5l-0.67,-2.83ZM413.26,252.79l0.07,-0.27l0.53,0.01l-0.14,0.32l-0.47,-0.07ZM413.39,249.66l-0.21,-0.43l0.16,-0.09l0.23,0.34l-0.18,0.19ZM406.71,256.46l0.77,1.0l0.47,2.45l0.4,0.33l0.73,-0.04l0.82,-0.96l0.52,0.72l0.47,2.25l-0.56,0.51l-1.03,-0.02l-0.95,0.43l-0.96,-1.46l0.1,-1.54l-0.89,-2.74l0.12,-0.93Z",
      name: "Vanuatu"
    }
  },
  height: 606.4292604642054,
  projection: { type: "mill", centralMeridian: 180.0 },
  width: 900.0
});
